/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.cql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CqlStrings {
    private static final Set<String> BUILT_IN_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ascii", "bigint", "blob", "boolean", "counter", "date", "decimal", "double", "duration", "float", "inet", "int", "smallint", "text", "time", "timestamp", "timeuuid", "tinyint", "tuple", "uuid", "varchar", "varint")));

    public static String quote(String value) {
        return CqlStrings.quote(value, '\'');
    }

    public static String doubleQuote(String value) {
        return CqlStrings.quote(value, '\"');
    }

    private static String quote(String text, char quoteChar) {
        if (text == null || text.isEmpty()) {
            return CqlStrings.emptyQuoted(quoteChar);
        }
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text.indexOf(quoteChar, start + 1)) == -1) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return quoteChar + text + quoteChar;
        }
        int newLength = 2 + text.length() + nbMatch;
        char[] result = new char[newLength];
        result[0] = quoteChar;
        result[newLength - 1] = quoteChar;
        int newIdx = 1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == quoteChar) {
                result[newIdx++] = c;
                result[newIdx++] = c;
                continue;
            }
            result[newIdx++] = c;
        }
        return new String(result);
    }

    private static String emptyQuoted(char quoteChar) {
        assert (quoteChar == '\"' || quoteChar == '\'');
        if (quoteChar == '\"') {
            return "\"\"";
        }
        return "''";
    }

    public static String doubleQuoteUdts(String dataTypeName) {
        if ((dataTypeName = dataTypeName.trim()).isEmpty()) {
            throw new IllegalArgumentException("Invalid empty type name");
        }
        int lastCharIdx = dataTypeName.length() - 1;
        if (dataTypeName.charAt(0) == '\'') {
            if (dataTypeName.charAt(lastCharIdx) != '\'' || dataTypeName.length() < 3) {
                throw new IllegalArgumentException("Malformed type name (missing closing quote): " + dataTypeName);
            }
            return dataTypeName;
        }
        if (dataTypeName.charAt(0) == '\"') {
            if (dataTypeName.charAt(lastCharIdx) != '\"' || dataTypeName.length() < 3) {
                throw new IllegalArgumentException("Malformed type name (missing closing quote): " + dataTypeName);
            }
            return dataTypeName;
        }
        int paramsIdx = dataTypeName.indexOf(60);
        if (paramsIdx < 0) {
            return BUILT_IN_TYPES.contains(dataTypeName) ? dataTypeName : CqlStrings.quote(dataTypeName, '\"');
        }
        String baseTypeName = dataTypeName.substring(0, paramsIdx).trim();
        if (dataTypeName.charAt(lastCharIdx) != '>') {
            throw new IllegalArgumentException(String.format("Malformed type name: parameters for type %s are missing a closing '>'", baseTypeName));
        }
        String paramsString = dataTypeName.substring(paramsIdx + 1, lastCharIdx);
        List<String> parameters = CqlStrings.splitParameters(paramsString, dataTypeName);
        return baseTypeName + parameters.stream().map(CqlStrings::doubleQuoteUdts).collect(Collectors.joining(", ", "<", ">"));
    }

    private static List<String> splitParameters(String parametersString, String fullTypeName) {
        int currentStart;
        int idx;
        int openParam = 0;
        ArrayList<String> parameters = new ArrayList<String>();
        block6: for (idx = currentStart = 0; idx < parametersString.length(); ++idx) {
            switch (parametersString.charAt(idx)) {
                case ',': {
                    if (openParam != 0) continue block6;
                    parameters.add(parametersString.substring(currentStart, idx));
                    currentStart = idx + 1;
                    continue block6;
                }
                case '<': {
                    ++openParam;
                    continue block6;
                }
                case '>': {
                    if (--openParam >= 0) continue block6;
                    throw new IllegalArgumentException("Malformed type name: " + fullTypeName + " (unmatched closing '>')");
                }
                case '\"': {
                    idx = CqlStrings.findClosingDoubleQuote(fullTypeName, parametersString, idx + 1) - 1;
                }
            }
        }
        parameters.add(parametersString.substring(currentStart, idx));
        return parameters;
    }

    private static int findClosingDoubleQuote(String fullTypeName, String str, int startIdx) {
        for (int idx = startIdx; idx < str.length(); ++idx) {
            if (str.charAt(idx) != '\"' || ++idx < str.length() && str.charAt(idx) == '\"') continue;
            return idx;
        }
        throw new IllegalArgumentException("Malformed type name: " + fullTypeName);
    }
}

