/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.core.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;

public class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static String toBase64(ByteBuffer buffer) {
        return ByteBufferUtils.toBase64(ByteBufferUtils.getArray(buffer));
    }

    public static String toBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static ByteBuffer fromBase64(String base64) {
        return ByteBuffer.wrap(Base64.getDecoder().decode(base64));
    }

    public static String toBase64ForUrl(ByteBuffer buffer) {
        return ByteBufferUtils.toBase64ForUrl(ByteBufferUtils.getArray(buffer));
    }

    public static String toBase64ForUrl(byte[] bytes) {
        return Base64.getUrlEncoder().encodeToString(bytes);
    }

    public static ByteBuffer fromBase64UrlParam(String base64) {
        return ByteBuffer.wrap(Base64.getUrlDecoder().decode(base64));
    }

    public static byte[] getArray(ByteBuffer bytes) {
        int length = bytes.remaining();
        if (bytes.hasArray()) {
            int boff = bytes.arrayOffset() + bytes.position();
            if (boff == 0 && length == bytes.array().length) {
                return bytes.array();
            }
            return Arrays.copyOfRange(bytes.array(), boff, boff + length);
        }
        byte[] array = new byte[length];
        bytes.duplicate().get(array);
        return array;
    }
}

