/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.core.metrics.impl;

import com.codahale.metrics.MetricRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.stargate.core.metrics.StargateMetricConstants;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.core.metrics.api.MetricsScraper;
import io.stargate.core.metrics.impl.MeterRegistryConfiguration;
import io.stargate.core.metrics.impl.PrefixingMetricRegistry;

public class MetricsImpl
implements Metrics,
MetricsScraper {
    private final MetricRegistry registry = new MetricRegistry();
    private final PrometheusMeterRegistry prometheusMeterRegistry = this.initPrometheusMeterRegistry(this.registry);

    private PrometheusMeterRegistry initPrometheusMeterRegistry(MetricRegistry metricRegistry) {
        DropwizardExports dropwizardExports = new DropwizardExports(metricRegistry);
        CollectorRegistry collectorRegistry = new CollectorRegistry();
        collectorRegistry.register(dropwizardExports);
        PrometheusMeterRegistry meterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT, collectorRegistry, Clock.SYSTEM);
        MeterRegistryConfiguration.configure(meterRegistry);
        return meterRegistry;
    }

    @Override
    public MetricRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public MetricRegistry getRegistry(String prefix) {
        return new PrefixingMetricRegistry(this.registry, prefix);
    }

    @Override
    public MeterRegistry getMeterRegistry() {
        return this.prometheusMeterRegistry;
    }

    @Override
    public Tags tagsForModule(String module) {
        Tag moduleTag = null != module ? Tag.of("module", module) : StargateMetricConstants.TAG_MODULE_UNKNOWN;
        return Tags.of(moduleTag);
    }

    @Override
    public String scrape() {
        return this.prometheusMeterRegistry.scrape();
    }
}

