/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=3000)
public class CharsetUtf8Filter
implements ContainerResponseFilter {
    private static final String UTF_8 = StandardCharsets.UTF_8.displayName(Locale.ENGLISH);

    @Override
    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        MediaType type = response.getMediaType();
        if (type != null && !type.getParameters().containsKey("charset")) {
            MediaType typeWithCharset = type.withCharset(UTF_8);
            response.getHeaders().putSingle("Content-Type", typeWithCharset);
        }
    }
}

