/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.language.Argument;
import graphql.language.ObjectField;
import graphql.language.Value;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.validation.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class ArgumentValidationUtil
extends ValidationUtil {
    private final List<String> argumentNames = new ArrayList<String>();
    private Value<?> argumentValue;
    private String errorMessage;
    private final List<Object> arguments = new ArrayList<Object>();
    private Map<String, Object> errorExtensions;
    private final String argumentName;

    public ArgumentValidationUtil(Argument argument) {
        this.argumentName = argument.getName();
        this.argumentValue = argument.getValue();
    }

    @Override
    protected void handleNullError(Value<?> value, GraphQLType type) {
        this.errorMessage = "must not be null";
        this.argumentValue = value;
    }

    @Override
    protected void handleScalarError(Value<?> value, GraphQLScalarType type, GraphQLError invalid) {
        this.errorMessage = "is not a valid '%s' - %s";
        this.arguments.add(type.getName());
        this.arguments.add(invalid.getMessage());
        this.argumentValue = value;
        this.errorExtensions = invalid.getExtensions();
    }

    @Override
    protected void handleEnumError(Value<?> value, GraphQLEnumType type, GraphQLError invalid) {
        this.errorMessage = "is not a valid '%s' - %s";
        this.arguments.add(type.getName());
        this.arguments.add(invalid.getMessage());
        this.argumentValue = value;
    }

    @Override
    protected void handleNotObjectError(Value<?> value, GraphQLInputObjectType type) {
        this.errorMessage = "must be an object type";
    }

    @Override
    protected void handleMissingFieldsError(Value<?> value, GraphQLInputObjectType type, Set<String> missingFields) {
        this.errorMessage = "is missing required fields '%s'";
        this.arguments.add(missingFields);
    }

    @Override
    protected void handleExtraFieldError(Value<?> value, GraphQLInputObjectType type, ObjectField objectField) {
        this.errorMessage = "contains a field not in '%s': '%s'";
        this.arguments.add(type.getName());
        this.arguments.add(objectField.getName());
    }

    @Override
    protected void handleFieldNotValidError(ObjectField objectField, GraphQLInputObjectType type) {
        this.argumentNames.add(0, objectField.getName());
    }

    @Override
    protected void handleFieldNotValidError(Value<?> value, GraphQLType type, int index) {
        this.argumentNames.add(0, String.format("[%s]", index));
    }

    public String getMessage() {
        StringBuilder argument = new StringBuilder(this.argumentName);
        for (String name : this.argumentNames) {
            if (name.startsWith("[")) {
                argument.append(name);
                continue;
            }
            argument.append(".").append(name);
        }
        this.arguments.add(0, argument.toString());
        this.arguments.add(1, this.argumentValue);
        String message = "argument '%s' with value '%s' " + this.errorMessage;
        return String.format(message, this.arguments.toArray());
    }

    public Map<String, Object> getErrorExtensions() {
        return this.errorExtensions;
    }
}

