/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation;

import graphql.PublicApi;
import graphql.execution.instrumentation.InstrumentationContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@PublicApi
public class SimpleInstrumentationContext<T>
implements InstrumentationContext<T> {
    private static final InstrumentationContext<Object> NO_OP = new SimpleInstrumentationContext<Object>();
    private final BiConsumer<T, Throwable> codeToRunOnComplete;
    private final Consumer<CompletableFuture<T>> codeToRunOnDispatch;

    public static <T> InstrumentationContext<T> noOp() {
        return NO_OP;
    }

    public SimpleInstrumentationContext() {
        this(null, null);
    }

    private SimpleInstrumentationContext(Consumer<CompletableFuture<T>> codeToRunOnDispatch, BiConsumer<T, Throwable> codeToRunOnComplete) {
        this.codeToRunOnComplete = codeToRunOnComplete;
        this.codeToRunOnDispatch = codeToRunOnDispatch;
    }

    @Override
    public void onDispatched(CompletableFuture<T> result) {
        if (this.codeToRunOnDispatch != null) {
            this.codeToRunOnDispatch.accept(result);
        }
    }

    @Override
    public void onCompleted(T result, Throwable t) {
        if (this.codeToRunOnComplete != null) {
            this.codeToRunOnComplete.accept(result, t);
        }
    }

    public static <U> SimpleInstrumentationContext<U> whenDispatched(Consumer<CompletableFuture<U>> codeToRun) {
        return new SimpleInstrumentationContext(codeToRun, null);
    }

    public static <U> SimpleInstrumentationContext<U> whenCompleted(BiConsumer<U, Throwable> codeToRun) {
        return new SimpleInstrumentationContext<U>(null, codeToRun);
    }
}

