/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.MaxOccurrences;
import com.github.rvesse.airline.annotations.restrictions.MinOccurrences;
import com.github.rvesse.airline.annotations.restrictions.Once;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.OccurrencesRestriction;
import com.github.rvesse.airline.restrictions.factories.ArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class OccurrencesRestrictionFactory
implements OptionRestrictionFactory,
ArgumentsRestrictionFactory {
    @Override
    public ArgumentsRestriction createArgumentsRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    @Override
    public OptionRestriction createOptionRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    protected OccurrencesRestriction createCommon(Annotation annotation) {
        if (annotation instanceof MaxOccurrences) {
            MaxOccurrences max = (MaxOccurrences)annotation;
            return new OccurrencesRestriction(max.occurrences(), true);
        }
        if (annotation instanceof MinOccurrences) {
            MinOccurrences min2 = (MinOccurrences)annotation;
            return new OccurrencesRestriction(min2.occurrences(), false);
        }
        if (annotation instanceof Once) {
            return new OccurrencesRestriction(1, true);
        }
        return null;
    }

    protected List<Class<? extends Annotation>> supportedAnnotations() {
        ArrayList<Class<? extends Annotation>> supported = new ArrayList<Class<? extends Annotation>>();
        supported.add(MaxOccurrences.class);
        supported.add(MinOccurrences.class);
        supported.add(Once.class);
        return supported;
    }

    @Override
    public List<Class<? extends Annotation>> supportedArgumentsAnnotations() {
        return this.supportedAnnotations();
    }

    @Override
    public List<Class<? extends Annotation>> supportedOptionAnnotations() {
        return this.supportedAnnotations();
    }
}

