/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseArgumentsMissingException;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.parser.errors.ParseTooManyArgumentsException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OccurrencesRestriction
extends AbstractCommonRestriction
implements HelpHint {
    private final int occurrences;
    private final boolean maximum;

    public OccurrencesRestriction(int occurrences, boolean maximum) {
        this.occurrences = occurrences;
        this.maximum = maximum;
    }

    @Override
    public <T> void finalValidate(ParseState<T> state, OptionMetadata option) {
        if (this.occurrences <= 0) {
            return;
        }
        Collection<Pair<OptionMetadata, Object>> parsedOptions = CollectionUtils.select(state.getParsedOptions(), new ParsedOptionFinder(option));
        if (this.maximum && parsedOptions.size() > this.occurrences) {
            throw new ParseRestrictionViolatedException("Option %s may be specified a maximum of %d times but was found %d times", AirlineUtils.first(option.getOptions()), this.occurrences, parsedOptions.size());
        }
        if (!this.maximum && parsedOptions.size() < this.occurrences) {
            throw new ParseRestrictionViolatedException("Option %s must be specified at least %d times but was only found %d times", AirlineUtils.first(option.getOptions()), this.occurrences, parsedOptions.size());
        }
    }

    @Override
    public <T> void finalValidate(ParseState<T> state, ArgumentsMetadata arguments) {
        if (this.occurrences <= 0) {
            return;
        }
        if (this.maximum && state.getParsedArguments().size() > this.occurrences) {
            throw new ParseTooManyArgumentsException("At most %d arguments may be specified but %d were found", this.occurrences, state.getParsedArguments().size());
        }
        if (!this.maximum && state.getParsedArguments().size() < this.occurrences) {
            throw new ParseArgumentsMissingException("At least %d arguments must be specified but only %d were found", this.titles(state, arguments), this.occurrences, state.getParsedArguments().size());
        }
    }

    private <T> List<String> titles(ParseState<T> state, ArgumentsMetadata arguments) {
        if (state.getParsedArguments().size() >= arguments.getTitle().size()) {
            return Collections.emptyList();
        }
        if (this.occurrences >= arguments.getTitle().size()) {
            return arguments.getTitle().subList(state.getParsedArguments().size(), arguments.getTitle().size());
        }
        return arguments.getTitle().subList(state.getParsedArguments().size(), this.occurrences);
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.maximum) {
            return new String[]{String.format("This option may occur a maximum of %d times", this.occurrences)};
        }
        return new String[]{String.format("This option must occur a minimum of %d times", this.occurrences)};
    }
}

