/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.errors.ParseOptionUnexpectedException;
import com.github.rvesse.airline.parser.options.AbstractOptionParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.lang3.StringUtils;

public class ListValueOptionParser<T>
extends AbstractOptionParser<T> {
    private static final char DEFAULT_SEPARATOR = ',';
    private final char separator;

    public ListValueOptionParser() {
        this(',');
    }

    public ListValueOptionParser(char separator) {
        if (Character.isWhitespace(separator)) {
            throw new IllegalArgumentException("List separator character cannot be a whitespace character");
        }
        this.separator = separator;
    }

    protected final List<String> getValues(String list) {
        ArrayList<String> values = new ArrayList<String>();
        for (String value : StringUtils.split(list, this.separator)) {
            values.add(value);
        }
        return values;
    }

    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        String list;
        String name = tokens.peek();
        boolean noSep = false;
        OptionMetadata option = this.findOption(state, allowedOptions, name);
        if (option == null) {
            if (this.hasShortNamePrefix(name) && name.length() > 2) {
                String shortName = name.substring(0, 2);
                option = this.findOption(state, allowedOptions, shortName);
                boolean bl = noSep = option != null;
            }
            if (!noSep) {
                return null;
            }
        }
        tokens.next();
        state = state.pushContext(Context.OPTION).withOption(option);
        String string = list = noSep ? name.substring(2) : null;
        if (option.getArity() == 0) {
            String rawBooleanValue = state.getParserConfiguration().allowsFlagNegation() && StringUtils.startsWith(name, state.getParserConfiguration().getFlagNegationPrefix()) ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
            state = state.withOptionValue(option, rawBooleanValue).popContext();
        } else {
            List<String> listValues;
            if (list == null) {
                if (!tokens.hasNext()) {
                    return state;
                }
                if (this.isSeparatorOrOption(state, allowedOptions, state.getParserConfiguration().getArgumentsSeparator(), false, tokens.peek())) {
                    this.noValueForOption(state, option);
                    return state;
                }
                list = tokens.next();
            }
            if ((listValues = this.getValues(list)).size() < option.getArity()) {
                state.getParserConfiguration().getErrorHandler().handleError(new ParseOptionMissingValueException("Too few option values received for option %s in list value '%s' (%d values expected but only found %d)", option.getOptions().iterator().next(), option.getOptions().iterator().next(), list, option.getArity(), listValues.size()));
                return state;
            }
            if (listValues.size() > option.getArity() && listValues.size() % option.getArity() != 0) {
                state.getParserConfiguration().getErrorHandler().handleError(new ParseOptionUnexpectedException("Too many option values received for option %s in list value '%s' (%d values expected but found %d)", option.getOptions().iterator().next(), list, option.getArity(), listValues.size()));
                return state;
            }
            for (String value : listValues) {
                state = state.withOptionValue(option, value);
            }
            state = state.popContext();
        }
        return state;
    }
}

