/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.options;

import com.github.rvesse.airline.Context;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionUnexpectedException;
import com.github.rvesse.airline.parser.options.AbstractOptionParser;
import java.util.List;
import org.apache.commons.collections4.iterators.PeekingIterator;

public class ClassicGetOptParser<T>
extends AbstractOptionParser<T> {
    @Override
    public ParseState<T> parseOptions(PeekingIterator<String> tokens, ParseState<T> state, List<OptionMetadata> allowedOptions) {
        if (!this.hasShortNamePrefix(tokens.peek())) {
            return null;
        }
        String remainingToken = tokens.peek().substring(1);
        ParseState<T> nextState = state;
        String argsSeparator = state.getParserConfiguration().getArgumentsSeparator();
        boolean first = true;
        while (!remainingToken.isEmpty()) {
            char tokenCharacter = remainingToken.charAt(0);
            OptionMetadata option = this.findOption(state, allowedOptions, "-" + tokenCharacter);
            if (option == null) {
                return null;
            }
            nextState = nextState.pushContext(Context.OPTION).withOption(option);
            remainingToken = remainingToken.substring(1);
            if (option.getArity() == 0) {
                nextState = nextState.withOptionValue(option, Boolean.TRUE.toString()).popContext();
                first = false;
                continue;
            }
            if (option.getArity() == 1) {
                tokens.next();
                if (!remainingToken.isEmpty()) {
                    if (this.isSeparatorOrOption(nextState, allowedOptions, argsSeparator, true, remainingToken)) {
                        this.noValueForOption(nextState, option);
                        return nextState;
                    }
                    nextState = nextState.withOptionValue(option, remainingToken).popContext();
                } else if (tokens.hasNext()) {
                    String peekedToken = tokens.peek();
                    if (this.isSeparatorOrOption(nextState, allowedOptions, argsSeparator, false, peekedToken)) {
                        this.noValueForOption(nextState, option);
                        return nextState;
                    }
                    nextState = nextState.withOptionValue(option, tokens.next()).popContext();
                }
                first = false;
                return nextState;
            }
            if (first) {
                return null;
            }
            state.getParserConfiguration().getErrorHandler().handleError(new ParseOptionUnexpectedException("Short options style can not be used with option %s as the arity was not 0 or 1", option));
            return nextState;
        }
        tokens.next();
        return nextState;
    }
}

