/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.execution.DataFetcherResult;
import graphql.language.OperationDefinition;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.MutationPayload;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.MutationResult;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.util.CompletableFutures;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

public abstract class MutationFetcher<MutationModelT extends MutationModel, ResultT>
extends DeployedFetcher<CompletionStage<ResultT>> {
    protected final MutationModelT model;

    protected MutationFetcher(MutationModelT model, MappingModel mappingModel) {
        super(mappingModel);
        this.model = model;
    }

    protected abstract MutationPayload<ResultT> getPayload(DataFetchingEnvironment var1, StargateGraphqlContext var2) throws UnauthorizedException;

    @Override
    protected CompletableFuture<ResultT> get(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        MutationPayload<ResultT> payload = null;
        Parameters parameters = null;
        Exception buildException = null;
        try {
            payload = this.getPayload(environment, context);
            parameters = this.buildParameters();
        }
        catch (Exception e) {
            buildException = e;
        }
        if (this.isAtomic(environment, payload)) {
            return this.executeAsPartOfBatch(payload, parameters, buildException, environment, context);
        }
        return this.executeAsIndividualQueries(payload, parameters, buildException, context);
    }

    private CompletableFuture<ResultT> executeAsPartOfBatch(MutationPayload<ResultT> payload, Parameters parameters, Exception buildException, DataFetchingEnvironment environment, StargateGraphqlContext context) {
        int totalSelections;
        StargateGraphqlContext.BatchContext batchContext = context.getBatchContext();
        if (buildException == null && !batchContext.setParameters(parameters)) {
            buildException = new GraphQLException("all the selections in an @atomic mutation must use the same consistency levels");
        }
        if (buildException != null) {
            batchContext.setExecutionResult((Exception)new GraphQLException("@atomic mutation aborted because one of the operations failed (see other errors for details)"));
            return CompletableFutures.failedFuture(buildException);
        }
        int currentSelections = batchContext.add(payload.getQueries());
        if (currentSelections == (totalSelections = environment.getOperationDefinition().getSelectionSet().getSelections().size()) && !batchContext.getExecutionFuture().isDone()) {
            batchContext.setExecutionResult(context.getDataStore().batch(batchContext.getQueries(), __ -> batchContext.getParameters()));
        }
        return batchContext.getExecutionFuture().thenApply(rows -> payload.getResultBuilder().apply(this.buildBatchResults((List<Row>)rows, payload)));
    }

    private List<MutationResult> buildBatchResults(List<Row> rows, MutationPayload<ResultT> payload) {
        List<BoundQuery> queries = payload.getQueries();
        List<List<TypedKeyValue>> primaryKeys = payload.getPrimaryKeys();
        ArrayList results = Lists.newArrayListWithCapacity((int)primaryKeys.size());
        if (this.isAppliedBatch(rows)) {
            for (int i = 0; i < queries.size(); ++i) {
                results.add(MutationResult.Applied.INSTANCE);
            }
        } else {
            int i = 0;
            for (BoundQuery query : queries) {
                Table table = ((BoundDMLQuery)query).table();
                List<TypedKeyValue> primaryKey = primaryKeys.get(i);
                MutationResult.NotApplied result = rows.stream().filter(row -> this.matches((Row)row, table, primaryKey)).findFirst().map(MutationResult.NotApplied::new).orElse(MutationResult.NotApplied.NO_ROW);
                results.add(result);
                ++i;
            }
        }
        return results;
    }

    private boolean matches(Row row, Table table, List<TypedKeyValue> primaryKey) {
        for (TypedKeyValue kv : primaryKey) {
            if (!row.columns().stream().noneMatch(c -> table.keyspace().equals(c.keyspace()) && table.name().equals(c.table()) && kv.getName().equals(c.name()) && kv.getType().equals(c.type())) && kv.getValue().equals(row.getObject(kv.getName()))) continue;
            return false;
        }
        return true;
    }

    private CompletableFuture<ResultT> executeAsIndividualQueries(MutationPayload<ResultT> payload, Parameters parameters, Exception buildException, StargateGraphqlContext context) {
        if (buildException != null) {
            return CompletableFutures.failedFuture(buildException);
        }
        List results = payload.getQueries().stream().map(query -> ((CompletableFuture)context.getDataStore().execute(query, __ -> parameters).thenApply(MutationResult::forSingleQuery)).exceptionally(MutationResult.Failure::new)).collect(Collectors.toList());
        return CompletableFutures.sequence(results).thenApply(payload.getResultBuilder());
    }

    private boolean isAtomic(DataFetchingEnvironment environment, MutationPayload<ResultT> payload) {
        OperationDefinition operation = environment.getOperationDefinition();
        return operation.getDirectives().stream().anyMatch(d -> d.getName().equals("atomic")) && (operation.getSelectionSet().getSelections().size() > 1 || payload.getQueries().size() > 1);
    }

    protected Parameters buildParameters() {
        ConsistencyLevel consistencyLevel = ((MutationModel)this.model).getConsistencyLevel().orElse(DEFAULT_CONSISTENCY);
        ConsistencyLevel serialConsistencyLevel = ((MutationModel)this.model).getSerialConsistencyLevel().orElse(DEFAULT_SERIAL_CONSISTENCY);
        if (consistencyLevel == DEFAULT_CONSISTENCY && serialConsistencyLevel == DEFAULT_SERIAL_CONSISTENCY) {
            return DEFAULT_PARAMETERS;
        }
        return DEFAULT_PARAMETERS.toBuilder().consistencyLevel(consistencyLevel).serialConsistencyLevel(serialConsistencyLevel).build();
    }

    protected ExceptionWhileDataFetching toGraphqlError(MutationResult.Failure failure, SourceLocation location, DataFetchingEnvironment environment) {
        return this.toGraphqlError(failure.getError(), location, environment);
    }

    protected ExceptionWhileDataFetching toGraphqlError(Throwable error, SourceLocation location, DataFetchingEnvironment environment) {
        return new ExceptionWhileDataFetching(environment.getExecutionStepInfo().getPath(), error, location);
    }

    protected SourceLocation getCurrentFieldLocation(DataFetchingEnvironment environment) {
        return environment.getMergedField().getSingleField().getSourceLocation();
    }

    protected Function<List<MutationResult>, DataFetcherResult<Object>> getDeleteOrUpdateResultBuilder(DataFetchingEnvironment environment) {
        return queryResults -> {
            DataFetcherResult.Builder result = DataFetcherResult.newResult();
            assert (queryResults.size() == 1);
            MutationResult queryResult = (MutationResult)queryResults.get(0);
            if (queryResult instanceof MutationResult.Failure) {
                result.error((GraphQLError)this.toGraphqlError((MutationResult.Failure)queryResult, this.getCurrentFieldLocation(environment), environment));
            } else {
                boolean applied = queryResult instanceof MutationResult.Applied;
                OperationModel.ReturnType returnType = ((MutationModel)this.model).getReturnType();
                if (returnType == OperationModel.SimpleReturnType.BOOLEAN) {
                    result.data((Object)applied);
                } else {
                    ResponsePayloadModel payload = (ResponsePayloadModel)returnType;
                    LinkedHashMap<String, Serializable> data = new LinkedHashMap<String, Serializable>();
                    if (payload.getTechnicalFields().contains((Object)ResponsePayloadModel.TechnicalField.APPLIED)) {
                        data.put(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName(), Boolean.valueOf(applied));
                    }
                    if (payload.getEntityField().isPresent()) {
                        LinkedHashMap entityData = new LinkedHashMap();
                        if (queryResult instanceof MutationResult.NotApplied) {
                            ((MutationResult.NotApplied)queryResult).getRow().ifPresent(row -> this.copyRowToEntity((Row)row, entityData, ((MutationModel)this.model).getEntity()));
                        }
                        data.put(payload.getEntityField().get().getName(), entityData);
                    }
                    result.data(data);
                }
            }
            return result.build();
        };
    }
}

