/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;
import java.util.Collections;
import java.util.List;

public class CreateUdtQuery
extends MigrationQuery {
    private final UserDefinedType type;

    public static List<MigrationQuery> createUdt(UserDefinedType type) {
        return Collections.singletonList(new CreateUdtQuery(type));
    }

    public CreateUdtQuery(UserDefinedType type) {
        this.type = type;
    }

    public UserDefinedType getType() {
        return this.type;
    }

    @Override
    public AbstractBound<?> build(DataStore dataStore) {
        return (AbstractBound)dataStore.queryBuilder().create().type(this.type.keyspace(), this.type).build().bind(new Object[0]);
    }

    @Override
    public String getDescription() {
        return "Create UDT " + this.type.name();
    }

    @Override
    public void authorize(AuthorizationService authorizationService, AuthenticationSubject subject) throws UnauthorizedException {
        authorizationService.authorizeSchemaWrite(subject, this.type.keyspace(), null, Scope.CREATE, SourceAPI.GRAPHQL, ResourceKind.TYPE);
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        return that.addsReferenceTo(this.type.name());
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return this.type.columns().stream().anyMatch(c -> this.references(c.type(), udtName));
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

