/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.DdlQueryFetcher;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CreateTypeFetcher
extends DdlQueryFetcher {
    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment environment, QueryBuilder builder, StargateGraphqlContext context) throws UnauthorizedException {
        String keyspaceName = (String)environment.getArgument("keyspaceName");
        String typeName = (String)environment.getArgument("typeName");
        context.getAuthorizationService().authorizeSchemaWrite(context.getSubject(), keyspaceName, null, Scope.CREATE, SourceAPI.GRAPHQL, ResourceKind.TYPE);
        List fieldList = (List)environment.getArgument("fields");
        if (fieldList.isEmpty()) {
            throw new IllegalArgumentException("Must have at least one field");
        }
        ArrayList<Column> fields = new ArrayList<Column>(fieldList.size());
        for (Map key : fieldList) {
            fields.add(Column.create((String)((String)key.get("name")), (Column.ColumnType)this.decodeType(key.get("type"))));
        }
        ImmutableUserDefinedType udt = ImmutableUserDefinedType.builder().keyspace(keyspaceName).name(typeName).addAllColumns(fields).build();
        Boolean ifNotExists = (Boolean)environment.getArgument("ifNotExists");
        return builder.create().type(keyspaceName, (UserDefinedType)udt).ifNotExists(ifNotExists != null && ifNotExists != false).build();
    }
}

