/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.scalars;

import com.datastax.oss.driver.api.core.data.CqlDuration;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import io.stargate.db.schema.Column;
import io.stargate.graphql.schema.scalars.BigIntCoercing;
import io.stargate.graphql.schema.scalars.DateCoercing;
import io.stargate.graphql.schema.scalars.FloatCoercing;
import io.stargate.graphql.schema.scalars.IntCoercing;
import io.stargate.graphql.schema.scalars.StringCoercing;
import io.stargate.graphql.schema.scalars.TimeCoercing;
import io.stargate.graphql.schema.scalars.TimestampCoercing;
import io.stargate.graphql.schema.scalars.VarintCoercing;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CqlScalar {
    UUID(Column.Type.Uuid, UUID.class, GraphQLScalarType.newScalar().name("Uuid").coercing(StringCoercing.UUID).description("Represents a CQL `uuid` as a string.\nExample: \"fe86cad0-1965-11eb-84e6-ab660d2e8c9e\"").build()),
    TIMEUUID(Column.Type.Timeuuid, UUID.class, GraphQLScalarType.newScalar().name("TimeUuid").coercing(StringCoercing.TIMEUUID).description("Represents a CQL `timeuuid` as a string.\nExample: \"fe86cad0-1965-11eb-84e6-ab660d2e8c9e\"").build()),
    INET(Column.Type.Inet, InetAddress.class, GraphQLScalarType.newScalar().name("Inet").coercing(StringCoercing.INET).description("Represents a CQL `inet` as a string.\nThis is an IP address in IPv4 or IPv6 format.\nExamples: \"127.0.0.1\", \"::1\"\nIf you don't provide a numerical address, it will be resolved on the server.").build()),
    DATE(Column.Type.Date, LocalDate.class, GraphQLScalarType.newScalar().name("Date").coercing((Coercing)DateCoercing.INSTANCE).description("Represents a CQL `date` as a string.\nThis is a date without a time-zone in the ISO-8601 calendar system.\nExample: \"2020-10-21\".\nA date can also be input as a 32-bit, positive numeric literal, which will be interpreted as a number of days, where the epoch is in the middle of the range (1970-01-01 = 2147483648).").build()),
    DURATION(Column.Type.Duration, CqlDuration.class, GraphQLScalarType.newScalar().name("Duration").coercing(StringCoercing.DURATION).description("Represents a CQL `duration` as a string.\nSee https://docs.datastax.com/en/dse/6.8/cql/cql/cql_reference/upsertDates.html\nExample: \"1h4m48s20ms\"").build()),
    BIGINT(Column.Type.Bigint, Long.class, GraphQLScalarType.newScalar().name("BigInt").coercing((Coercing)BigIntCoercing.INSTANCE).description("Represents a CQL `bigint` as an integer literal.\nThis is a 64-bit signed integer.").build()),
    COUNTER(Column.Type.Counter, Long.class, GraphQLScalarType.newScalar().name("Counter").coercing((Coercing)BigIntCoercing.INSTANCE).description("Represents a CQL `counter` as an integer literal.\nThis is a 64-bit signed integer.").build()),
    ASCII(Column.Type.Ascii, String.class, GraphQLScalarType.newScalar().name("Ascii").coercing(StringCoercing.ASCII).description("Represents a CQL `ascii` as a string.\nAn error will be thrown if the string contains non-ASCII characters.").build()),
    DECIMAL(Column.Type.Decimal, BigDecimal.class, GraphQLScalarType.newScalar().name("Decimal").coercing(StringCoercing.DECIMAL).description("Represents a CQL `decimal` as a string.\nThis is a variable-precision decimal.\nExamples: \"1.5\", \"1e-3\"").build()),
    VARINT(Column.Type.Varint, BigInteger.class, GraphQLScalarType.newScalar().name("Varint").coercing((Coercing)VarintCoercing.INSTANCE).description("Represents a CQL `varint` as an integer.\nThis is an arbitrary-precision integer.\nExamples: 1, 9223372036854775808").build()),
    FLOAT(Column.Type.Float, Float.class, GraphQLScalarType.newScalar().name("Float32").coercing((Coercing)FloatCoercing.INSTANCE).description("Represents a CQL `float` as a floating-point literal.\nThis is a 32-bit IEEE-754 floating point.\nIf the value cannot be represented as a float, it will be converted. This conversion can loose precision, or range (resulting in +/-Infinity).").build()),
    BLOB(Column.Type.Blob, ByteBuffer.class, GraphQLScalarType.newScalar().name("Blob").coercing(StringCoercing.BLOB).description("Represents a CQL `blob` as a base64 encoded string.\nExample: \"yv4=\" (for the hex value 0xCAFE)").build()),
    SMALLINT(Column.Type.Smallint, Short.class, GraphQLScalarType.newScalar().name("SmallInt").coercing(IntCoercing.SMALLINT).description("Represents a CQL `smallint` as an integer.\nThis is a 16-bit signed int.\nAn error will be thrown if the value is out of bounds.").build()),
    TINYINT(Column.Type.Tinyint, Byte.class, GraphQLScalarType.newScalar().name("TinyInt").coercing(IntCoercing.TINYINT).description("Represents a CQL `tinyint` as an integer\n.This is an 8-bit signed int.\nAn error will be thrown if the value is out of bounds.").build()),
    TIMESTAMP(Column.Type.Timestamp, Instant.class, GraphQLScalarType.newScalar().name("Timestamp").coercing((Coercing)TimestampCoercing.INSTANCE).description("Represents a CQL `timestamp` as a string.\nThis is an instantaneous point on the time-line.\nThis type supports many different string representations (see https://docs.datastax.com/en/cql-oss/3.x/cql/cql_reference/timestamp_type_r.html). A timestamp can also be input as a numeric literal, which will be interpreted as a number of milliseconds since the epoch (1970-01-01 UTC at midnight).\nExamples: \"2011-02-03 04:05+0000\", 1296705900000\nString literals that do not include any time zone information will be interpreted using the server's default time zone.").build()),
    TIME(Column.Type.Time, LocalTime.class, GraphQLScalarType.newScalar().name("Time").coercing((Coercing)TimeCoercing.INSTANCE).description("Represents a CQL `time` as a string.\nThis is a time without a time-zone in the ISO-8601 calendar system.\nExample: \"10:15:30.123456789\"\nA time can also be input as a numeric literal, which will be interpreted as a number of nanoseconds since midnight.").build());

    private static final Map<Column.Type, CqlScalar> FROM_CQL;
    private static final Map<String, CqlScalar> FROM_GRAPHQL_NAME;
    private final Column.Type cqlType;
    private final Class<?> cqlValueClass;
    private final GraphQLScalarType graphqlType;

    private CqlScalar(Column.Type cqlType, Class<?> cqlValueClass, GraphQLScalarType graphqlType) {
        this.cqlType = cqlType;
        this.cqlValueClass = cqlValueClass;
        this.graphqlType = graphqlType;
    }

    public Column.Type getCqlType() {
        return this.cqlType;
    }

    public Class<?> getCqlValueClass() {
        return this.cqlValueClass;
    }

    public GraphQLScalarType getGraphqlType() {
        return this.graphqlType;
    }

    public static Optional<CqlScalar> fromCqlType(Column.Type cqlType) {
        return Optional.ofNullable(FROM_CQL.get(cqlType));
    }

    public static Optional<CqlScalar> fromGraphqlName(String graphqlName) {
        return Optional.ofNullable(FROM_GRAPHQL_NAME.get(graphqlName));
    }

    static {
        FROM_CQL = Arrays.stream(CqlScalar.values()).collect(Collectors.toMap(CqlScalar::getCqlType, Function.identity()));
        FROM_GRAPHQL_NAME = Arrays.stream(CqlScalar.values()).collect(Collectors.toMap(s -> s.getGraphqlType().getName(), Function.identity()));
    }
}

