/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.util;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import graphql.Scalars;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.scalars.CqlScalar;
import java.util.Map;
import java.util.Set;

public class TypeHelper {
    private static final Set<String> UUID_TYPE_NAMES = ImmutableSet.of((Object)Scalars.GraphQLID.getName(), (Object)CqlScalar.UUID.getGraphqlType().getName(), (Object)CqlScalar.TIMEUUID.getGraphqlType().getName());

    public static boolean deepEquals(Type<?> type1, Type<?> type2) {
        if (type1 instanceof ListType && type2 instanceof ListType) {
            return TypeHelper.deepEquals(((ListType)type1).getType(), ((ListType)type2).getType());
        }
        if (type1 instanceof NonNullType && type2 instanceof NonNullType) {
            return TypeHelper.deepEquals(((NonNullType)type1).getType(), ((NonNullType)type2).getType());
        }
        if (type1 instanceof TypeName && type2 instanceof TypeName) {
            return type1.isEqualTo(type2);
        }
        return false;
    }

    public static boolean mapsToUuid(Type<?> type) {
        if ((type = TypeHelper.unwrapNonNull(type)) instanceof TypeName) {
            TypeName typeName = (TypeName)type;
            return UUID_TYPE_NAMES.contains(typeName.getName());
        }
        return false;
    }

    public static boolean isGraphqlId(Type<?> type) {
        return (type = TypeHelper.unwrapNonNull(type)) instanceof TypeName && Scalars.GraphQLID.getName().equals(((TypeName)type).getName());
    }

    public static Type<?> unwrapNonNull(Type<?> type) {
        return type instanceof NonNullType ? ((NonNullType)type).getType() : type;
    }

    public static Type<?> toInput(Type<?> type, Map<String, EntityModel> entities) {
        if (type instanceof NonNullType) {
            Type<?> elementType = TypeHelper.toInput(((NonNullType)type).getType(), entities);
            return NonNullType.newNonNullType(elementType).build();
        }
        if (type instanceof ListType) {
            Type<?> elementType = TypeHelper.toInput(((ListType)type).getType(), entities);
            return ListType.newListType(elementType).build();
        }
        assert (type instanceof TypeName);
        String typeName = ((TypeName)type).getName();
        EntityModel entity = entities.get(typeName);
        if (entity == null) {
            return type;
        }
        String inputTypeName = entity.getInputTypeName().orElseThrow(() -> new IllegalArgumentException(String.format("type %s has no input type", typeName)));
        return TypeName.newTypeName((String)inputTypeName).build();
    }

    public static String format(Type<?> type) {
        if (type instanceof NonNullType) {
            return TypeHelper.format(((NonNullType)type).getType()) + '!';
        }
        if (type instanceof ListType) {
            return "[" + TypeHelper.format(((ListType)type).getType()) + "]";
        }
        assert (type instanceof TypeName);
        return ((TypeName)type).getName();
    }

    private TypeHelper() {
    }
}

