/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.Argument;
import graphql.language.BooleanValue;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.EnumValue;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.language.Value;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingErrorType;
import java.util.Optional;
import java.util.function.Function;

class DirectiveHelper {
    static Optional<Directive> getDirective(String name, DirectivesContainer<?> container) {
        if (container.hasDirective(name)) {
            return Optional.of(container.getDirectives(name).get(0));
        }
        return Optional.empty();
    }

    public static boolean hasDirective(InputValueDefinition inputValue, String directive) {
        return DirectiveHelper.getDirective(directive, inputValue).isPresent();
    }

    static Optional<String> getStringArgument(Directive directive, String argumentName, ProcessingContext context) {
        return DirectiveHelper.getArgument(directive, argumentName, StringValue.class, v -> Optional.of(v.getValue()), context);
    }

    static Optional<Boolean> getBooleanArgument(Directive directive, String argumentName, ProcessingContext context) {
        return DirectiveHelper.getArgument(directive, argumentName, BooleanValue.class, v -> Optional.of(v.isValue()), context);
    }

    static Optional<Integer> getIntArgument(Directive directive, String argumentName, ProcessingContext context) {
        return DirectiveHelper.getArgument(directive, argumentName, IntValue.class, v -> {
            try {
                return Optional.of(v.getValue().intValueExact());
            }
            catch (ArithmeticException e) {
                context.addError(directive.getSourceLocation(), ProcessingErrorType.InvalidSyntax, "%s.%s: value '%s' out of range, expected a 32-bit signed integer", directive.getName(), argumentName, v.getValue());
                return Optional.empty();
            }
        }, context);
    }

    static <EnumT extends Enum<EnumT>> Optional<EnumT> getEnumArgument(Directive directive, String argumentName, Class<EnumT> enumClass, ProcessingContext context) {
        return DirectiveHelper.getArgument(directive, argumentName, EnumValue.class, v -> {
            try {
                return Optional.of(Enum.valueOf(enumClass, v.getName()));
            }
            catch (IllegalArgumentException e) {
                context.addError(directive.getSourceLocation(), ProcessingErrorType.InvalidSyntax, "%s.%s: invalid value '%s', must be an enum constant", directive.getName(), argumentName, v.getName());
                return Optional.empty();
            }
        }, context);
    }

    static <ResultT, ValueT extends Value<ValueT>> Optional<ResultT> getArgument(Directive directive, String argumentName, Class<ValueT> valueClass, Function<ValueT, Optional<ResultT>> extractor, ProcessingContext context) {
        return Optional.ofNullable(directive.getArgument(argumentName)).map(Argument::getValue).filter(v -> {
            if (valueClass.isInstance(v)) {
                return true;
            }
            context.addError(directive.getSourceLocation(), ProcessingErrorType.InvalidSyntax, "%s.%s: invalid value, expected a %s", directive.getName(), argumentName, valueClass.getSimpleName());
            return false;
        }).flatMap(v -> (Optional)extractor.apply(valueClass.cast(v)));
    }

    private DirectiveHelper() {
    }
}

