/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class AddUdtFieldQuery
extends MigrationQuery {
    private final UserDefinedType type;
    private final Column column;

    public AddUdtFieldQuery(UserDefinedType type, Column column) {
        this.type = type;
        this.column = column;
    }

    @Override
    public AbstractBound<?> build(DataStore dataStore) {
        return (AbstractBound)dataStore.queryBuilder().alter().type(this.type.keyspace(), this.type).addColumn(this.column).build().bind(new Object[0]);
    }

    @Override
    public String getDescription() {
        return String.format("Add field %s to UDT %s", this.column.name(), this.type.name());
    }

    @Override
    public void authorize(AuthorizationService authorizationService, AuthenticationSubject subject) throws UnauthorizedException {
        authorizationService.authorizeSchemaWrite(subject, this.type.keyspace(), null, Scope.ALTER, SourceAPI.GRAPHQL, ResourceKind.TYPE);
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        return false;
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return this.references(this.column.type(), udtName);
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

