/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import io.stargate.db.schema.Column;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.graphqlfirst.processor.IndexTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CassandraSchemaHelper {
    public static List<Difference> compare(Table expectedTable, Table actualTable) {
        String tableName = expectedTable.name();
        if (!tableName.equals(actualTable.name())) {
            throw new IllegalArgumentException("This should only be called for tables with the same name");
        }
        ArrayList<Difference> differences = new ArrayList<Difference>();
        for (Column expectedColumn : expectedTable.columns()) {
            Column actualColumn = actualTable.column(expectedColumn.name());
            CassandraSchemaHelper.compareColumn(expectedColumn, actualColumn, differences);
            SecondaryIndex expectedIndex = CassandraSchemaHelper.findSecondaryIndex(expectedTable, expectedColumn);
            if (expectedIndex == null) continue;
            SecondaryIndex actualIndex = actualColumn == null ? null : CassandraSchemaHelper.findSecondaryIndex(actualTable, actualColumn);
            CassandraSchemaHelper.compareIndex(expectedIndex, actualIndex, expectedColumn, differences);
        }
        return differences;
    }

    private static void compareColumn(Column expectedColumn, Column actualColumn, List<Difference> differences) {
        Column.ColumnType expectedType = expectedColumn.type();
        assert (expectedType != null);
        if (actualColumn == null) {
            String description = null;
            if (expectedColumn.isPartitionKey()) {
                description = "it can't be added because it is marked as a partition key";
            } else if (expectedColumn.isClusteringKey()) {
                description = "it can't be added because it is marked as a clustering column";
            }
            differences.add(new Difference(expectedColumn, DifferenceType.MISSING_COLUMN, description));
        } else if (!CassandraSchemaHelper.equals(expectedType, actualColumn.type())) {
            differences.add(new Difference(expectedColumn, DifferenceType.WRONG_TYPE, String.format("expected %s, found %s", expectedType.cqlDefinition(), actualColumn.type().cqlDefinition())));
        } else if (expectedColumn.kind() != actualColumn.kind()) {
            differences.add(new Difference(expectedColumn, DifferenceType.WRONG_KIND, String.format("expected %s, found %s", expectedColumn.kind(), actualColumn.kind())));
        } else if (expectedColumn.kind() == Column.Kind.Clustering && expectedColumn.order() != actualColumn.order()) {
            differences.add(new Difference(expectedColumn, DifferenceType.WRONG_CLUSTERING_ORDER, String.format("expected %s, found %s", expectedColumn.order(), actualColumn.order())));
        }
    }

    private static boolean equals(Column.ColumnType expectedType, Column.ColumnType actualType) {
        if (actualType.rawType() != expectedType.rawType()) {
            return false;
        }
        if (actualType.isUserDefined()) {
            return actualType.name().equals(expectedType.name());
        }
        if (actualType.isParameterized()) {
            List actualParameters = actualType.parameters();
            List expectedParameters = expectedType.parameters();
            if (actualParameters.size() != expectedParameters.size()) {
                return false;
            }
            for (int i = 0; i < actualParameters.size(); ++i) {
                if (CassandraSchemaHelper.equals((Column.ColumnType)expectedParameters.get(i), (Column.ColumnType)actualParameters.get(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static SecondaryIndex findSecondaryIndex(Table table, Column column) {
        if (column == null) {
            return null;
        }
        return table.indexes().stream().filter(index -> index instanceof SecondaryIndex && column.equals(((SecondaryIndex)index).column())).findFirst().orElse(null);
    }

    private static void compareIndex(SecondaryIndex expectedIndex, SecondaryIndex actualIndex, Column expectedColumn, List<Difference> differences) {
        if (actualIndex == null) {
            differences.add(new Difference(expectedColumn, expectedIndex, DifferenceType.MISSING_INDEX, null));
            return;
        }
        String description = null;
        if (!Objects.equals(expectedIndex.name(), actualIndex.name())) {
            description = String.format("expected name %s, found %s", expectedIndex.name(), actualIndex.name());
        } else if (!Objects.equals(expectedIndex.indexingClass(), actualIndex.indexingClass())) {
            description = String.format("expected index class %s, found %s", expectedIndex.indexingClass(), actualIndex.indexingClass());
        } else if (!Objects.equals(expectedIndex.indexingType(), actualIndex.indexingType())) {
            description = String.format("expected index target %s, found %s", new Object[]{IndexTarget.fromIndexingType(expectedIndex.indexingType()), IndexTarget.fromIndexingType(actualIndex.indexingType())});
        } else if (!Objects.equals(expectedIndex.indexingOptions(), actualIndex.indexingOptions())) {
            description = String.format("expected index options %s, found %s", expectedIndex.indexingOptions(), actualIndex.indexingOptions());
        }
        if (description != null) {
            differences.add(new Difference(expectedColumn, expectedIndex, DifferenceType.WRONG_INDEX, description));
        }
    }

    public static List<Difference> compare(UserDefinedType expectedType, UserDefinedType actualType) {
        String typeName = expectedType.name();
        if (!typeName.equals(actualType.name())) {
            throw new IllegalArgumentException("This should only be called for UDTs with the same name");
        }
        ArrayList<Difference> differences = new ArrayList<Difference>();
        for (Column expectedColumn : expectedType.columns()) {
            Column actualColumn = (Column)actualType.columnMap().get(expectedColumn.name());
            CassandraSchemaHelper.compareColumn(expectedColumn, actualColumn, differences);
        }
        return differences;
    }

    private CassandraSchemaHelper() {
    }

    public static class Difference {
        private final Column column;
        private final SecondaryIndex index;
        private final DifferenceType type;
        private final String description;

        public Difference(Column column, SecondaryIndex index, DifferenceType type, String description) {
            this.column = column;
            this.index = index;
            this.type = type;
            this.description = description;
        }

        public Difference(Column column, DifferenceType type, String description) {
            this(column, null, type, description);
        }

        public Column getColumn() {
            return this.column;
        }

        public SecondaryIndex getIndex() {
            return this.index;
        }

        public DifferenceType getType() {
            return this.type;
        }

        public String toGraphqlMessage() {
            return String.format("[%s] %s.%s%s", new Object[]{this.type, this.column.table(), this.column.name(), this.description == null ? "" : ": " + this.description});
        }
    }

    public static enum DifferenceType {
        MISSING_COLUMN,
        WRONG_TYPE,
        WRONG_KIND,
        WRONG_CLUSTERING_ORDER,
        MISSING_INDEX,
        WRONG_INDEX;

    }
}

