/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import io.stargate.db.query.Predicate;
import io.stargate.graphql.schema.graphqlfirst.processor.ConditionModelBuilderBase;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import java.util.Map;
import java.util.Optional;

class IfConditionModelBuilder
extends ConditionModelBuilderBase {
    IfConditionModelBuilder(InputValueDefinition argument, Optional<Directive> directive, EntityModel entity, FieldModel field, String operationName, Map<String, EntityModel> entities, ProcessingContext context) {
        super(argument, directive, entity, field, operationName, entities, context);
    }

    @Override
    protected void validate(FieldModel field, Predicate predicate) throws SkipException {
        if (field.isPartitionKey()) {
            this.invalidMapping("Operation %s: @%s is not supported for partition keys (field %s)", new Object[]{this.operationName, "cql_if", field.getGraphqlName()});
        }
        if (field.isClusteringColumn()) {
            this.invalidMapping("Operation %s: @%s is not supported for clustering keys (field %s)", new Object[]{this.operationName, "cql_if", field.getGraphqlName()});
        } else {
            this.checkValidForRegularColumn(predicate, field);
        }
    }

    private void checkValidForRegularColumn(Predicate predicate, FieldModel field) throws SkipException {
        switch (predicate) {
            case EQ: 
            case NEQ: 
            case LT: 
            case GT: 
            case LTE: 
            case GTE: {
                this.checkArgumentIsSameAs(field);
                break;
            }
            case IN: {
                this.checkArgumentIsListOf(field);
                break;
            }
            default: {
                this.invalidMapping("Operation %s: predicate %s is not supported for field %s (expected EQ, NEQ, LT, GT, LTE or GTE)", new Object[]{this.operationName, predicate, field.getGraphqlName()});
                throw SkipException.INSTANCE;
            }
        }
    }
}

