/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.Modification;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.query.builder.Value;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.MutationFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.TtlFromOptionsExtractor;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateMutationFetcher
extends MutationFetcher {
    public UpdateMutationFetcher(Table table, NameMapping nameMapping) {
        super(table, nameMapping);
    }

    @Override
    protected BoundQuery buildQuery(DataFetchingEnvironment environment, StargateGraphqlContext context) throws UnauthorizedException {
        boolean ifExists = environment.containsArgument("ifExists") && environment.getArgument("ifExists") != null && (Boolean)environment.getArgument("ifExists") != false;
        BoundQuery query = context.getDataStore().queryBuilder().update(this.table.keyspace(), this.table.name()).ttl(TtlFromOptionsExtractor.getTTL(environment)).value(this.buildAssignments(this.table, environment)).where(this.buildPkCKWhere(this.table, environment)).ifs(this.buildConditions(this.table, (Map)environment.getArgument("ifCondition"))).ifExists(ifExists).build().bind(new Object[0]);
        context.getAuthorizationService().authorizeDataWrite(context.getSubject(), this.table.keyspace(), this.table.name(), TypedKeyValue.forDML((BoundDMLQuery)((BoundDMLQuery)query)), Scope.MODIFY, SourceAPI.GRAPHQL);
        return query;
    }

    private List<BuiltCondition> buildPkCKWhere(Table table, DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        ArrayList<BuiltCondition> relations = new ArrayList<BuiltCondition>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.dbColumnGetter.getColumn(table, (String)entry.getKey());
            if (!table.partitionKeyColumns().contains(column) && !table.clusteringKeyColumns().contains(column)) continue;
            relations.add(BuiltCondition.of((String)column.name(), (Predicate)Predicate.EQ, (Object)this.toDBValue(column, entry.getValue())));
        }
        return relations;
    }

    private List<ValueModifier> buildAssignments(Table table, DataFetchingEnvironment environment) {
        Map value = (Map)environment.getArgument("value");
        ArrayList<ValueModifier> assignments = new ArrayList<ValueModifier>();
        for (Map.Entry entry : value.entrySet()) {
            Column column = this.dbColumnGetter.getColumn(table, (String)entry.getKey());
            if (table.partitionKeyColumns().contains(column) || table.clusteringKeyColumns().contains(column)) continue;
            Modification.Operation operation = column.type() == Column.Type.Counter ? Modification.Operation.INCREMENT : Modification.Operation.SET;
            assignments.add(ValueModifier.of((String)column.name(), (Value)Value.of((Object)this.toDBValue(column, entry.getValue())), (Modification.Operation)operation));
        }
        return assignments;
    }
}

