/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.graphqlfirst.migration.CreateTableQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.DropUdtQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class DropTableQuery
extends MigrationQuery {
    private final Table table;

    public DropTableQuery(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    @Override
    public AbstractBound<?> build(DataStore dataStore) {
        return (AbstractBound)dataStore.queryBuilder().drop().table(this.table.keyspace(), this.table.name()).ifExists().build().bind(new Object[0]);
    }

    @Override
    public String getDescription() {
        return "Drop table " + this.table.name();
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        if (that instanceof CreateTableQuery) {
            return this.table.name().equals(((CreateTableQuery)that).getTable().name());
        }
        if (that instanceof DropUdtQuery) {
            return this.dropsReferenceTo(((DropUdtQuery)that).getType().name());
        }
        return false;
    }

    @Override
    public void authorize(AuthorizationService authorizationService, AuthenticationSubject subject) throws UnauthorizedException {
        authorizationService.authorizeSchemaWrite(subject, this.table.keyspace(), this.table.name(), Scope.DROP, SourceAPI.GRAPHQL, ResourceKind.TABLE);
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return false;
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return this.table.columns().stream().anyMatch(c -> this.references(c.type(), udtName));
    }
}

