/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.deployed;

import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.SourceLocation;
import graphql.language.Value;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.ValueModifier;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.MutationFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.MutationPayload;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.MutationResult;
import io.stargate.graphql.schema.graphqlfirst.fetchers.deployed.TimestampParser;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.graphql.schema.graphqlfirst.processor.InsertModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.util.TypeHelper;
import io.stargate.graphql.schema.graphqlfirst.util.Uuids;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InsertFetcher
extends MutationFetcher<InsertModel, DataFetcherResult<Object>> {
    public InsertFetcher(InsertModel model, MappingModel mappingModel) {
        super(model, mappingModel);
    }

    @Override
    protected MutationPayload<DataFetcherResult<Object>> getPayload(DataFetchingEnvironment environment, StargateGraphqlContext context) throws UnauthorizedException {
        DataFetchingFieldSelectionSet selectionSet = environment.getSelectionSet();
        EntityModel entityModel = ((InsertModel)this.model).getEntity();
        boolean isLwt = ((InsertModel)this.model).ifNotExists();
        String entityPrefixInResponse = ((InsertModel)this.model).getResponsePayload().flatMap(ResponsePayloadModel::getEntityField).map(ResponsePayloadModel.EntityField::getName).orElse(null);
        Keyspace keyspace = context.getDataStore().schema().keyspace(entityModel.getKeyspaceName());
        List<Map<String, Object>> inputs = ((InsertModel)this.model).isList() ? (List<Map<String, Object>>)environment.getArgument(((InsertModel)this.model).getEntityArgumentName()) : Collections.singletonList((Map)environment.getArgument(((InsertModel)this.model).getEntityArgumentName()));
        ArrayList<BoundQuery> queries = new ArrayList<BoundQuery>();
        ArrayList<List<TypedKeyValue>> primaryKeys = new ArrayList<List<TypedKeyValue>>();
        ArrayList cqlValuesList = Lists.newArrayListWithCapacity((int)inputs.size());
        for (Map map : inputs) {
            Map<String, Object> cqlValues = this.buildCqlValues(entityModel, keyspace, map);
            Collection modifiers = cqlValues.entrySet().stream().map(e -> ValueModifier.set((String)((String)e.getKey()), e.getValue())).collect(Collectors.toList());
            Optional<Long> timestamp = TimestampParser.parse(((InsertModel)this.model).getCqlTimestampArgumentName(), environment);
            AbstractBound<?> query = this.buildInsertQuery(entityModel, modifiers, timestamp, isLwt, context);
            List primaryKey = TypedKeyValue.forDML((BoundDMLQuery)((BoundDMLQuery)query));
            this.authorizeInsert(entityModel, primaryKey, context);
            queries.add((BoundQuery)query);
            primaryKeys.add(primaryKey);
            cqlValuesList.add(cqlValues);
        }
        Function<List<MutationResult>, DataFetcherResult<Object>> resultBuilder = this.getResultBuilder(selectionSet, entityPrefixInResponse, inputs, cqlValuesList, environment);
        return new MutationPayload<DataFetcherResult<Object>>(queries, primaryKeys, resultBuilder);
    }

    private AbstractBound<?> buildInsertQuery(EntityModel entityModel, Collection<ValueModifier> modifiers, Optional<Long> timestamp, boolean isLwt, StargateGraphqlContext context) {
        return (AbstractBound)context.getDataStore().queryBuilder().insertInto(entityModel.getKeyspaceName(), entityModel.getCqlName()).value(modifiers).ifNotExists(isLwt).ttl((Integer)((InsertModel)this.model).getTtl().orElse(null)).timestamp((Long)timestamp.orElse(null)).build().bind(new Object[0]);
    }

    private void authorizeInsert(EntityModel entityModel, List<TypedKeyValue> primaryKey, StargateGraphqlContext context) throws UnauthorizedException {
        context.getAuthorizationService().authorizeDataWrite(context.getSubject(), entityModel.getKeyspaceName(), entityModel.getCqlName(), primaryKey, Scope.MODIFY, SourceAPI.GRAPHQL);
    }

    private Function<List<MutationResult>, DataFetcherResult<Object>> getResultBuilder(DataFetchingFieldSelectionSet selectionSet, String entityPrefixInResponse, List<Map<String, Object>> inputs, List<Map<String, Object>> cqlValuesList, DataFetchingEnvironment environment) {
        return queryResults -> {
            DataFetcherResult.Builder result = DataFetcherResult.newResult();
            ArrayList<Object> data = new ArrayList<Object>();
            int i = 0;
            for (MutationResult queryResult : queryResults) {
                if (queryResult instanceof MutationResult.Failure) {
                    result.error((GraphQLError)this.toGraphqlError((MutationResult.Failure)queryResult, this.getInputLocation(i, environment), environment));
                    data.add(null);
                } else if (this.isBooleanReturnType()) {
                    data.add(queryResult instanceof MutationResult.Applied);
                } else if (this.isEntityReturnType()) {
                    data.add(this.buildEntityResponse(queryResult, (Map)inputs.get(i), (Map)cqlValuesList.get(i)));
                } else if (this.isPayloadModelReturnType()) {
                    data.add(this.buildPayloadResponse(queryResult, entityPrefixInResponse, (Map)inputs.get(i), (Map)cqlValuesList.get(i), selectionSet));
                } else {
                    result.error((GraphQLError)this.toGraphqlError(new IllegalArgumentException("Unsupported return type: " + ((InsertModel)this.model).getReturnType()), this.getCurrentFieldLocation(environment), environment));
                    data.add(null);
                }
                ++i;
            }
            return result.data(((InsertModel)this.model).isList() ? data : data.get(0)).build();
        };
    }

    private SourceLocation getInputLocation(int inputIndex, DataFetchingEnvironment environment) {
        Argument argument = environment.getField().getArguments().stream().filter(a -> a.getName().equals(((InsertModel)this.model).getEntityArgumentName())).findFirst().orElseThrow(() -> new AssertionError((Object)"Entity argument should be present"));
        if (((InsertModel)this.model).isList()) {
            ArrayValue arrayValue = (ArrayValue)argument.getValue();
            return ((Value)arrayValue.getValues().get(inputIndex)).getSourceLocation();
        }
        return argument.getSourceLocation();
    }

    private Map<String, Object> buildPayloadResponse(MutationResult queryResult, String entityPrefixInResponse, Map<String, Object> input, Map<String, Object> cqlValues, DataFetchingFieldSelectionSet selectionSet) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        if (entityPrefixInResponse != null) {
            LinkedHashMap<String, Object> entityInResponse = new LinkedHashMap<String, Object>();
            response.put(entityPrefixInResponse, entityInResponse);
            if (queryResult instanceof MutationResult.Applied) {
                this.copyInputDataToResponse(input, cqlValues, entityInResponse);
            } else if (queryResult instanceof MutationResult.NotApplied) {
                ((MutationResult.NotApplied)queryResult).getRow().ifPresent(row -> this.copyRowToEntity((Row)row, (Map<String, Object>)entityInResponse, ((InsertModel)this.model).getEntity()));
            }
        }
        if (selectionSet.contains(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName())) {
            response.put(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName(), queryResult instanceof MutationResult.Applied);
        }
        return response;
    }

    private Map<String, Object> buildEntityResponse(MutationResult queryResult, Map<String, Object> input, Map<String, Object> cqlValues) {
        LinkedHashMap<String, Object> entityResponse = new LinkedHashMap<String, Object>();
        if (queryResult instanceof MutationResult.Applied) {
            this.copyInputDataToResponse(input, cqlValues, entityResponse);
        } else if (queryResult instanceof MutationResult.NotApplied) {
            ((MutationResult.NotApplied)queryResult).getRow().ifPresent(row -> this.copyRowToEntity((Row)row, (Map<String, Object>)entityResponse, ((InsertModel)this.model).getEntity()));
        }
        return entityResponse;
    }

    private boolean isBooleanReturnType() {
        OperationModel.ReturnType returnType = ((InsertModel)this.model).getReturnType();
        return returnType == OperationModel.SimpleReturnType.BOOLEAN || returnType instanceof OperationModel.SimpleListReturnType && ((OperationModel.SimpleListReturnType)returnType).getSimpleReturnType().equals(OperationModel.SimpleReturnType.BOOLEAN);
    }

    private boolean isPayloadModelReturnType() {
        return ((InsertModel)this.model).getResponsePayload().flatMap(ResponsePayloadModel::getEntityField).isPresent();
    }

    private boolean isEntityReturnType() {
        return ((InsertModel)this.model).getReturnType() instanceof OperationModel.EntityReturnType || ((InsertModel)this.model).getReturnType() instanceof OperationModel.EntityListReturnType;
    }

    private Map<String, Object> buildCqlValues(EntityModel entityModel, Keyspace keyspace, Map<String, Object> input) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (FieldModel column : entityModel.getAllColumns()) {
            Object cqlValue;
            String graphqlName = column.getGraphqlName();
            if (input.containsKey(graphqlName)) {
                Object graphqlValue = input.get(graphqlName);
                cqlValue = this.toCqlValue(graphqlValue, column.getCqlType(), keyspace);
            } else {
                if (!column.isPrimaryKey()) continue;
                if (TypeHelper.mapsToUuid(column.getGraphqlType())) {
                    cqlValue = this.generateUuid(column.getCqlType());
                } else {
                    throw new IllegalArgumentException("Missing value for field " + graphqlName);
                }
            }
            values.put(column.getCqlName(), cqlValue);
        }
        return values;
    }

    private Object generateUuid(Column.ColumnType cqlType) {
        if (cqlType == Column.Type.Uuid) {
            return UUID.randomUUID();
        }
        if (cqlType == Column.Type.Timeuuid) {
            return Uuids.timeBased();
        }
        throw new AssertionError((Object)("This shouldn't get called for CQL type " + cqlType));
    }

    private void copyInputDataToResponse(Map<String, Object> input, Map<String, Object> cqlValues, Map<String, Object> entityData) {
        for (FieldModel column : ((InsertModel)this.model).getEntity().getAllColumns()) {
            Object graphqlValue;
            String graphqlName = column.getGraphqlName();
            if (input.containsKey(graphqlName)) {
                graphqlValue = input.get(graphqlName);
            } else {
                if (!column.isPrimaryKey()) continue;
                Object cqlValue = cqlValues.get(column.getCqlName());
                assert (cqlValue instanceof UUID);
                graphqlValue = cqlValue.toString();
            }
            entityData.put(graphqlName, graphqlValue);
        }
    }
}

