/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import graphql.GraphqlErrorException;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.stargate.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModelFactory;
import io.stargate.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingErrorType;
import io.stargate.graphql.schema.graphqlfirst.processor.QueryModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingModel {
    private static final Logger LOG = LoggerFactory.getLogger(MappingModel.class);
    private static final Predicate<ObjectTypeDefinition> IS_RESPONSE_PAYLOAD = t -> DirectiveHelper.getDirective("cql_payload", t).isPresent();
    private final Map<String, EntityModel> entities;
    private final Map<String, ResponsePayloadModel> responses;
    private final List<OperationModel> operations;
    private final boolean hasUserQueries;

    MappingModel(Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responses, List<OperationModel> operations, boolean hasUserQueries) {
        this.entities = entities;
        this.responses = responses;
        this.operations = operations;
        this.hasUserQueries = hasUserQueries;
    }

    public Map<String, EntityModel> getEntities() {
        return this.entities;
    }

    public Map<String, ResponsePayloadModel> getResponses() {
        return this.responses;
    }

    public boolean hasFederatedEntities() {
        return this.getEntities().values().stream().anyMatch(EntityModel::isFederated);
    }

    public List<OperationModel> getOperations() {
        return this.operations;
    }

    public boolean hasUserQueries() {
        return this.hasUserQueries;
    }

    static MappingModel build(TypeDefinitionRegistry registry, ProcessingContext context) {
        Optional<ObjectTypeDefinition> maybeQueryType = MappingModel.getOperationType(registry, "query", "Query");
        Optional<ObjectTypeDefinition> maybeMutationType = MappingModel.getOperationType(registry, "mutation", "Mutation");
        Optional<ObjectTypeDefinition> maybeSubscriptionType = MappingModel.getOperationType(registry, "subscription", "Subscription");
        maybeSubscriptionType.ifPresent(t -> context.addError(t.getSourceLocation(), ProcessingErrorType.InvalidMapping, "This GraphQL implementation does not support subscriptions", new Object[0]));
        Set<ObjectTypeDefinition> typesToIgnore = ImmutableList.of(maybeQueryType, maybeMutationType, maybeSubscriptionType).stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        Map<String, EntityModel> entities = MappingModel.buildEntities(registry, typesToIgnore, context);
        if (!maybeQueryType.isPresent() && entities.values().stream().noneMatch(EntityModel::isFederated)) {
            context.addError(null, ProcessingErrorType.InvalidSyntax, "A schema MUST have a 'query' operation defined", new Object[0]);
        }
        Map<String, ResponsePayloadModel> responsePayloads = MappingModel.buildResponsePayloads(registry, typesToIgnore, entities, context);
        ImmutableList.Builder operationsBuilder = ImmutableList.builder();
        maybeQueryType.ifPresent(queryType -> MappingModel.buildQueries(queryType, entities, responsePayloads, (ImmutableList.Builder<OperationModel>)operationsBuilder, context));
        maybeMutationType.ifPresent(mutationType -> MappingModel.buildMutations(mutationType, entities, responsePayloads, (ImmutableList.Builder<OperationModel>)operationsBuilder, context));
        if (!context.getErrors().isEmpty()) {
            String schemaOrigin = context.isPersisted() ? "stored for this keyspace" : "that you provided";
            throw ((GraphqlErrorException.Builder)((GraphqlErrorException.Builder)GraphqlErrorException.newErrorException().message(String.format("The GraphQL schema %s contains CQL mapping errors. See details in `extensions.mappingErrors` below.", schemaOrigin))).extensions((Map)ImmutableMap.of((Object)"mappingErrors", context.getErrors()))).build();
        }
        return new MappingModel(entities, responsePayloads, (List<OperationModel>)operationsBuilder.build(), maybeQueryType.isPresent());
    }

    private static Optional<ObjectTypeDefinition> getOperationType(TypeDefinitionRegistry registry, String fieldName, String defaultTypeName) {
        String typeName = registry.schemaDefinition().flatMap(schema -> {
            for (OperationTypeDefinition operation : schema.getOperationTypeDefinitions()) {
                if (!operation.getName().equals(fieldName)) continue;
                return Optional.of(operation.getTypeName().getName());
            }
            return Optional.empty();
        }).orElse(defaultTypeName);
        return registry.getType(typeName).filter(t -> t instanceof ObjectTypeDefinition).map(t -> (ObjectTypeDefinition)t);
    }

    private static Map<String, EntityModel> buildEntities(TypeDefinitionRegistry registry, Set<ObjectTypeDefinition> typesToIgnore, ProcessingContext context) {
        ImmutableMap.Builder entitiesBuilder = ImmutableMap.builder();
        registry.getTypes(ObjectTypeDefinition.class).stream().filter(t -> !typesToIgnore.contains(t)).filter(IS_RESPONSE_PAYLOAD.negate()).forEach(type -> {
            try {
                entitiesBuilder.put((Object)type.getName(), (Object)new EntityModelBuilder((ObjectTypeDefinition)type, context).build());
            }
            catch (SkipException e) {
                LOG.debug("Skipping type {} because it has mapping errors, this will be reported after the whole schema has been processed.", (Object)type.getName());
            }
        });
        return entitiesBuilder.build();
    }

    private static Map<String, ResponsePayloadModel> buildResponsePayloads(TypeDefinitionRegistry registry, Set<ObjectTypeDefinition> typesToIgnore, Map<String, EntityModel> entities, ProcessingContext context) {
        ImmutableMap.Builder responsePayloadsBuilder = ImmutableMap.builder();
        registry.getTypes(ObjectTypeDefinition.class).stream().filter(t -> !typesToIgnore.contains(t)).filter(IS_RESPONSE_PAYLOAD).forEach(type -> responsePayloadsBuilder.put((Object)type.getName(), (Object)new ResponsePayloadModelBuilder((ObjectTypeDefinition)type, entities, context).build()));
        return responsePayloadsBuilder.build();
    }

    private static void buildQueries(ObjectTypeDefinition queryType, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ImmutableList.Builder<OperationModel> operationsBuilder, ProcessingContext context) {
        for (FieldDefinition query : queryType.getFieldDefinitions()) {
            try {
                operationsBuilder.add((Object)new QueryModelBuilder(query, queryType.getName(), entities, responsePayloads, context).build());
            }
            catch (SkipException e) {
                LOG.debug("Skipping query {} because it has mapping errors, this will be reported after the whole schema has been processed.", (Object)query.getName());
            }
        }
    }

    private static void buildMutations(ObjectTypeDefinition mutationType, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ImmutableList.Builder<OperationModel> operationsBuilder, ProcessingContext context) {
        for (FieldDefinition mutation : mutationType.getFieldDefinitions()) {
            try {
                operationsBuilder.add((Object)MutationModelFactory.build(mutation, mutationType.getName(), entities, responsePayloads, context));
            }
            catch (SkipException e) {
                LOG.debug("Skipping mutation {} because it has mapping errors, this will be reported after the whole schema has been processed.", (Object)mutation.getName());
            }
        }
    }
}

