/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.graphqlfirst.migration.CreateUdtQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class DropUdtQuery
extends MigrationQuery {
    private final UserDefinedType type;

    public DropUdtQuery(UserDefinedType type) {
        this.type = type;
    }

    public UserDefinedType getType() {
        return this.type;
    }

    @Override
    public AbstractBound<?> build(DataStore dataStore) {
        return (AbstractBound)dataStore.queryBuilder().drop().type(this.type.keyspace(), this.type).ifExists().build().bind(new Object[0]);
    }

    @Override
    public String getDescription() {
        return "Drop UDT " + this.type.name();
    }

    @Override
    public void authorize(AuthorizationService authorizationService, AuthenticationSubject subject) throws UnauthorizedException {
        authorizationService.authorizeSchemaWrite(subject, this.type.keyspace(), null, Scope.DROP, SourceAPI.GRAPHQL, ResourceKind.TYPE);
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        if (that instanceof CreateUdtQuery) {
            return this.type.name().equals(((CreateUdtQuery)that).getType().name());
        }
        if (that instanceof DropUdtQuery) {
            return this.dropsReferenceTo(((DropUdtQuery)that).getType().name());
        }
        return false;
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return false;
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return this.type.columns().stream().anyMatch(c -> this.references(c.type(), udtName));
    }
}

