/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers;

import graphql.GraphQLException;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DmlFetcher;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BulkMutationFetcher
extends DmlFetcher<CompletableFuture<List<Map<String, Object>>>> {
    protected BulkMutationFetcher(Table table, NameMapping nameMapping) {
        super(table, nameMapping);
    }

    @Override
    protected CompletableFuture<List<Map<String, Object>>> get(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        List<Object> queries = new ArrayList();
        Exception buildException = null;
        try {
            queries = this.buildQueries(environment, context);
        }
        catch (Exception e) {
            buildException = e;
        }
        OperationDefinition operation = environment.getOperationDefinition();
        if (this.containsDirective(operation, "atomic") && (operation.getSelectionSet().getSelections().size() > 1 || queries.size() > 1)) {
            return this.executeAsPartOfBatch(environment, queries, buildException, operation);
        }
        if (buildException != null) {
            CompletableFuture<List<Map<String, Object>>> f = new CompletableFuture<List<Map<String, Object>>>();
            f.completeExceptionally(buildException);
            return f;
        }
        List values = (List)environment.getArgument("values");
        if (values.size() != queries.size()) {
            throw new IllegalStateException("Number of values to insert should match number of queries");
        }
        ArrayList results = new ArrayList(values.size());
        Parameters parameters = this.buildParameters(environment);
        for (int i = 0; i < queries.size(); ++i) {
            int finalI = i;
            if (this.containsDirective(operation, "async")) {
                results.add(this.executeAsyncAccepted((BoundQuery)queries.get(i), values.get(finalI), __ -> parameters, context));
                continue;
            }
            results.add((CompletableFuture)context.getDataStore().execute((BoundQuery)queries.get(i), __ -> parameters).thenApply(rs -> this.toMutationResult((ResultSet)rs, values.get(finalI))));
        }
        return BulkMutationFetcher.convert(results);
    }

    private CompletableFuture<List<Map<String, Object>>> executeAsPartOfBatch(DataFetchingEnvironment environment, List<BoundQuery> queries, Exception buildException, OperationDefinition operation) {
        int selections = environment.getOperationDefinition().getSelectionSet().getSelections().size();
        StargateGraphqlContext context = (StargateGraphqlContext)environment.getContext();
        StargateGraphqlContext.BatchContext batchContext = context.getBatchContext();
        if (environment.getArgument("options") != null && !batchContext.setParameters(this.buildParameters(environment))) {
            buildException = new GraphQLException("options can only de defined once in an @atomic mutation selection");
        }
        if (buildException != null) {
            batchContext.setExecutionResult(buildException);
        } else if (batchContext.add(queries) == selections) {
            batchContext.setExecutionResult(context.getDataStore().batch(batchContext.getQueries(), __ -> batchContext.getParameters()));
        }
        List values = (List)environment.getArgument("values");
        if (this.containsDirective(operation, "async")) {
            return this.toListOfMutationResultsAccepted(values);
        }
        return batchContext.getExecutionFuture().thenApply(rows -> this.toBatchResults((List<Row>)rows, values));
    }

    public static <T> CompletableFuture<List<T>> convert(List<CompletableFuture<T>> futures) {
        return futures.stream().map(f -> f.thenApply(Stream::of)).reduce((a, b) -> a.thenCompose(xs -> b.thenApply(ys -> Stream.concat(xs, ys)))).map(f -> f.thenApply(s -> s.collect(Collectors.toList()))).orElse(CompletableFuture.completedFuture(Collections.emptyList()));
    }

    protected abstract List<BoundQuery> buildQueries(DataFetchingEnvironment var1, StargateGraphqlContext var2) throws Exception;
}

