/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import io.stargate.db.schema.CollectionIndexingType;
import java.util.Map;
import java.util.Optional;

public class IndexModel {
    public static final String SAI_INDEX_CLASS_NAME = "org.apache.cassandra.index.sai.StorageAttachedIndex";
    private final String name;
    private final Optional<String> indexClass;
    private final CollectionIndexingType indexingType;
    private final Map<String, String> options;

    IndexModel(String name, Optional<String> indexClass, CollectionIndexingType indexingType, Map<String, String> options) {
        this.name = name;
        this.indexClass = indexClass;
        this.indexingType = indexingType;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getIndexClass() {
        return this.indexClass;
    }

    public boolean isBuiltIn() {
        return this.getIndexClass().map(c -> c.equals(SAI_INDEX_CLASS_NAME)).orElse(true);
    }

    public CollectionIndexingType getIndexingType() {
        return this.indexingType;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }
}

