/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.errorprone.annotations.FormatMethod;
import graphql.language.SourceLocation;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingErrorType;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;

abstract class ModelBuilderBase<ModelT> {
    protected final ProcessingContext context;
    protected final SourceLocation location;

    protected ModelBuilderBase(ProcessingContext context, SourceLocation location) {
        this.context = context;
        this.location = location;
    }

    abstract ModelT build() throws SkipException;

    @FormatMethod
    protected void info(String format, Object ... arguments) {
        this.context.addInfo(this.location, format, arguments);
    }

    @FormatMethod
    protected void warn(String format, Object ... arguments) {
        this.context.addWarning(this.location, format, arguments);
    }

    @FormatMethod
    public void invalidMapping(String format, Object ... arguments) {
        this.context.addError(this.location, ProcessingErrorType.InvalidMapping, format, arguments);
    }

    @FormatMethod
    protected void invalidSyntax(String format, Object ... arguments) {
        this.context.addError(this.location, ProcessingErrorType.InvalidSyntax, format, arguments);
    }
}

