/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import graphql.schema.GraphQLType;
import graphql.schema.idl.SchemaPrinter;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.graphqlfirst.processor.CqlDirectives;
import io.stargate.graphql.schema.scalars.CqlScalar;
import io.stargate.graphql.web.resources.Authenticated;
import io.stargate.graphql.web.resources.AuthenticationFilter;
import io.stargate.graphql.web.resources.DmlResource;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/graphql-files")
@Authenticated
public class FilesResource {
    private static final Logger LOG = LoggerFactory.getLogger(FilesResource.class);
    private static final String DIRECTIVES_RESPONSE = FilesResource.buildDirectivesResponse();
    private final AuthorizationService authorizationService;

    @Inject
    public FilesResource(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @GET
    @Path(value="/cql_directives.graphql")
    @Produces(value={"text/plain"})
    public Response getCqlDirectives() {
        return Response.ok((Object)DIRECTIVES_RESPONSE).header("Content-Disposition", (Object)"inline; filename=\"cql_directives.graphql\"").build();
    }

    @GET
    @Path(value="/keyspace/{keyspaceName}.graphql")
    @Produces(value={"text/plain"})
    public Response getSchema(@HeaderParam(value="X-Cassandra-Token") String token, @PathParam(value="keyspaceName") String keyspace, @QueryParam(value="version") String version, @Context HttpServletRequest httpRequest) throws Exception {
        if (!DmlResource.KEYSPACE_NAME_PATTERN.matcher(keyspace).matches()) {
            LOG.warn("Malformed keyspace in URI, this could be an XSS attack: {}", (Object)keyspace);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Malformed keyspace name").build();
        }
        UUID versionUuid = null;
        if (version != null) {
            try {
                versionUuid = UUID.fromString(version);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Malformed version in URI, this could be an XSS attack: {}", (Object)version);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Malformed version").build();
            }
        }
        try {
            AuthenticationSubject authenticationSubject = (AuthenticationSubject)httpRequest.getAttribute(AuthenticationFilter.SUBJECT_KEY);
            this.authorizationService.authorizeSchemaRead(authenticationSubject, Collections.singletonList("stargate_graphql"), Collections.singletonList("schema_source"), SourceAPI.GRAPHQL, ResourceKind.TABLE);
            DataStore dataStore = (DataStore)httpRequest.getAttribute(AuthenticationFilter.DATA_STORE_KEY);
            SchemaSource schemaSource = new SchemaSourceDao(dataStore).getSingleVersion(keyspace, Optional.ofNullable(versionUuid));
            if (schemaSource == null) {
                return this.notFound(keyspace, version);
            }
            return Response.ok((Object)schemaSource.getContents()).header("Content-Disposition", (Object)("inline; filename=" + this.createFileName(schemaSource))).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    private Response notFound(String keyspace, String version) {
        return Response.status((int)Response.Status.NOT_FOUND.getStatusCode(), (String)String.format("The schema for keyspace %s and version %s does not exist.", keyspace, version)).build();
    }

    private String createFileName(SchemaSource schemaSource) {
        return String.format("\"%s-%s.graphql\"", schemaSource.getKeyspace(), schemaSource.getVersion());
    }

    private static String buildDirectivesResponse() {
        StringBuilder result = new StringBuilder(CqlDirectives.ALL_AS_STRING);
        result.append('\n');
        SchemaPrinter schemaPrinter = new SchemaPrinter();
        for (CqlScalar cqlScalar : CqlScalar.values()) {
            result.append(schemaPrinter.print((GraphQLType)cqlScalar.getGraphqlType()));
        }
        return result.toString();
    }
}

