/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.migration;

import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class AddTableColumnQuery
extends MigrationQuery {
    private final Table table;
    private final Column column;

    public AddTableColumnQuery(Table table, Column column) {
        this.table = table;
        this.column = column;
    }

    @Override
    public AbstractBound<?> build(DataStore dataStore) {
        return (AbstractBound)dataStore.queryBuilder().alter().table(this.table.keyspace(), this.table.name()).addColumn(this.column).build().bind(new Object[0]);
    }

    @Override
    public String getDescription() {
        return String.format("Add column %s to table %s", this.column.name(), this.table.name());
    }

    @Override
    public void authorize(AuthorizationService authorizationService, AuthenticationSubject subject) throws UnauthorizedException {
        authorizationService.authorizeSchemaWrite(subject, this.table.keyspace(), this.table.name(), Scope.ALTER, SourceAPI.GRAPHQL, ResourceKind.TABLE);
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        if (that instanceof AddTableColumnQuery) {
            return false;
        }
        return !that.mustRunBefore(this);
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return this.references(this.column.type(), udtName);
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

