/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.ddl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.db.query.builder.Replication;
import io.stargate.graphql.schema.cqlfirst.ddl.fetchers.DdlQueryFetcher;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateKeyspaceFetcher
extends DdlQueryFetcher {
    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment environment, QueryBuilder builder, StargateGraphqlContext context) throws UnauthorizedException {
        String keyspaceName = (String)environment.getArgument("name");
        context.getAuthorizationService().authorizeSchemaWrite(context.getSubject(), keyspaceName, null, Scope.CREATE, SourceAPI.GRAPHQL, ResourceKind.KEYSPACE);
        boolean ifNotExists = (Boolean)environment.getArgumentOrDefault("ifNotExists", (Object)Boolean.FALSE);
        Integer replicas = (Integer)environment.getArgument("replicas");
        List datacenters = (List)environment.getArgument("datacenters");
        if (replicas == null && datacenters == null) {
            throw new IllegalArgumentException("You must specify either replicas or datacenters");
        }
        if (replicas != null && datacenters != null) {
            throw new IllegalArgumentException("You can't specify both replicas and datacenters");
        }
        Replication replication = replicas != null ? Replication.simpleStrategy((int)replicas) : Replication.networkTopologyStrategy(this.parseDatacenters(datacenters));
        return builder.create().keyspace(keyspaceName).ifNotExists(ifNotExists).withReplication(replication).build();
    }

    private Map<String, Integer> parseDatacenters(List<Map<String, Object>> datacenters) {
        assert (datacenters != null);
        if (datacenters.isEmpty()) {
            throw new IllegalArgumentException("datacenters must contain at least one element");
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map<String, Object> datacenter : datacenters) {
            String dcName = (String)datacenter.get("name");
            Integer dcReplicas = (Integer)datacenter.getOrDefault("replicas", 3);
            result.put(dcName, dcReplicas);
        }
        return result;
    }
}

