/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.google.common.collect.ImmutableMap;
import graphql.GraphQLException;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.DmlFetcher;
import io.stargate.graphql.web.HttpAwareContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public abstract class MutationFetcher
extends DmlFetcher<CompletableFuture<Map<String, Object>>> {
    protected MutationFetcher(Table table, NameMapping nameMapping, AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(table, nameMapping, authenticationService, authorizationService, dataStoreFactory);
    }

    @Override
    protected CompletableFuture<Map<String, Object>> get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) {
        BoundQuery query = null;
        Exception buildException = null;
        try {
            query = this.buildQuery(environment, dataStore, authenticationSubject);
        }
        catch (Exception e) {
            buildException = e;
        }
        OperationDefinition operation = environment.getOperationDefinition();
        if (operation.getDirectives().stream().anyMatch(d -> d.getName().equals("atomic")) && operation.getSelectionSet().getSelections().size() > 1) {
            return this.executeAsBatch(environment, dataStore, query, buildException);
        }
        if (buildException != null) {
            CompletableFuture<Map<String, Object>> f = new CompletableFuture<Map<String, Object>>();
            f.completeExceptionally(buildException);
            return f;
        }
        return dataStore.execute(query).thenApply(rs -> ImmutableMap.of((Object)"value", (Object)environment.getArgument("value")));
    }

    private CompletableFuture<Map<String, Object>> executeAsBatch(DataFetchingEnvironment environment, DataStore dataStore, BoundQuery query, Exception buildException) {
        boolean dataStoreAlreadySet;
        int selections = environment.getOperationDefinition().getSelectionSet().getSelections().size();
        HttpAwareContext context = (HttpAwareContext)environment.getContext();
        HttpAwareContext.BatchContext batchContext = context.getBatchContext();
        if (environment.getArgument("options") != null && (dataStoreAlreadySet = batchContext.setDataStore(dataStore))) {
            buildException = new GraphQLException("options can only de defined once in an @atomic mutation selection");
        }
        if (buildException != null) {
            batchContext.setExecutionResult(buildException);
        } else if (batchContext.add(query) == selections) {
            DataStore batchDataStore = batchContext.getDataStore().orElse(dataStore);
            batchContext.setExecutionResult(batchDataStore.batch(batchContext.getQueries()));
        }
        return batchContext.getExecutionFuture().thenApply(v -> ImmutableMap.of((Object)"value", (Object)environment.getArgument("value")));
    }

    protected abstract BoundQuery buildQuery(DataFetchingEnvironment var1, DataStore var2, AuthenticationSubject var3) throws Exception;

    protected Integer getTTL(DataFetchingEnvironment environment) {
        Map options;
        Integer ttl = null;
        if (environment.containsArgument("options") && environment.getArgument("options") != null && (options = (Map)environment.getArgument("options")).containsKey("ttl") && options.get("ttl") != null) {
            ttl = (Integer)options.get("ttl");
        }
        return ttl;
    }
}

