/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.builder.BuiltCondition;
import io.stargate.db.schema.Column;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.DataTypeMapping;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class FilterOperator
extends Enum<FilterOperator> {
    public static final /* enum */ FilterOperator EQUAL = new FilterOperator("eq", Predicate.EQ);
    public static final /* enum */ FilterOperator NOT_EQUAL = new FilterOperator("notEq", Predicate.NEQ);
    public static final /* enum */ FilterOperator GREATER_THAN = new FilterOperator("gt", Predicate.GT);
    public static final /* enum */ FilterOperator GREATER_THAN_EQUAL = new FilterOperator("gte", Predicate.GTE);
    public static final /* enum */ FilterOperator LESS_THAN = new FilterOperator("lt", Predicate.LT);
    public static final /* enum */ FilterOperator LESS_THAN_EQUAL = new FilterOperator("lte", Predicate.LTE);
    public static final /* enum */ FilterOperator IN = new FilterOperator("in", Predicate.IN){

        @Override
        protected Object conditionValue(Column.ColumnType type, Object graphCQLValue, NameMapping nameMapping) {
            if (graphCQLValue instanceof Collection) {
                Collection values = (Collection)graphCQLValue;
                return values.stream().map(item -> DataTypeMapping.toDBValue(type, item, nameMapping)).collect(Collectors.toList());
            }
            return Collections.singletonList(DataTypeMapping.toDBValue(type, graphCQLValue, nameMapping));
        }

        @Override
        public GraphQLInputObjectField buildField(GraphQLInputType gqlInputType) {
            return GraphQLInputObjectField.newInputObjectField().name(this.getFieldName()).type((GraphQLInputType)GraphQLList.list((GraphQLType)gqlInputType)).build();
        }
    };
    public static final /* enum */ FilterOperator CONTAINS = new FilterOperator("contains", Predicate.CONTAINS){

        @Override
        protected Object conditionValue(Column.ColumnType type, Object graphCQLValue, NameMapping nameMapping) {
            assert (type.isCollection());
            Column.ColumnType elementType = (Column.ColumnType)type.parameters().get(type.isMap() ? 1 : 0);
            return DataTypeMapping.toDBValue(elementType, graphCQLValue, nameMapping);
        }
    };
    public static final /* enum */ FilterOperator CONTAINS_KEY = new FilterOperator("containsKey", Predicate.CONTAINS_KEY){

        @Override
        protected Object conditionValue(Column.ColumnType type, Object graphCQLValue, NameMapping nameMapping) {
            assert (type.isMap());
            Column.ColumnType keyType = (Column.ColumnType)type.parameters().get(0);
            return DataTypeMapping.toDBValue(keyType, graphCQLValue, nameMapping);
        }
    };
    public static final /* enum */ FilterOperator CONTAINS_ENTRY = new FilterOperator("containsEntry", Predicate.EQ){

        private Map<String, Object> entry(Object graphCQLValue) {
            return (Map)graphCQLValue;
        }

        @Override
        protected BuiltCondition.LHS conditionLHS(Column column, Object graphCQLValue, NameMapping nameMapping) {
            Object key = DataTypeMapping.toDBValue((Column.ColumnType)column.type().parameters().get(0), this.entry(graphCQLValue).get("key"), nameMapping);
            return BuiltCondition.LHS.mapAccess((String)column.name(), (Object)key);
        }

        @Override
        protected Object conditionValue(Column.ColumnType type, Object graphCQLValue, NameMapping nameMapping) {
            return DataTypeMapping.toDBValue((Column.ColumnType)type.parameters().get(1), this.entry(graphCQLValue).get("value"), nameMapping);
        }
    };
    private static final Map<String, FilterOperator> mapByFieldName;
    private final String fieldName;
    private final Predicate predicate;
    private static final /* synthetic */ FilterOperator[] $VALUES;

    public static FilterOperator[] values() {
        return (FilterOperator[])$VALUES.clone();
    }

    public static FilterOperator valueOf(String name) {
        return Enum.valueOf(FilterOperator.class, name);
    }

    public static FilterOperator fromFieldName(String fieldName) {
        FilterOperator op = mapByFieldName.get(fieldName);
        if (op == null) {
            throw new IllegalArgumentException("Invalid filter field name: " + fieldName);
        }
        return op;
    }

    private static Map<String, FilterOperator> buildMapByFieldName() {
        return Arrays.stream(FilterOperator.values()).collect(Collectors.toMap(FilterOperator::getFieldName, o -> o));
    }

    public BuiltCondition buildCondition(Column column, Object value, NameMapping nameMapping) {
        Column.ColumnType type = column.type();
        assert (type != null);
        return BuiltCondition.of((BuiltCondition.LHS)this.conditionLHS(column, value, nameMapping), (Predicate)this.predicate, (Object)this.conditionValue(type, value, nameMapping));
    }

    protected BuiltCondition.LHS conditionLHS(Column column, Object graphCQLValue, NameMapping nameMapping) {
        return BuiltCondition.LHS.column((String)column.name());
    }

    protected Object conditionValue(Column.ColumnType type, Object graphCQLValue, NameMapping nameMapping) {
        return DataTypeMapping.toDBValue(type, graphCQLValue, nameMapping);
    }

    public GraphQLInputObjectField buildField(GraphQLInputType gqlInputType) {
        return GraphQLInputObjectField.newInputObjectField().name(this.fieldName).type(gqlInputType).build();
    }

    private FilterOperator(String fieldName, Predicate predicate) {
        this.fieldName = fieldName;
        this.predicate = predicate;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Predicate predicate() {
        return this.predicate;
    }

    static {
        $VALUES = new FilterOperator[]{EQUAL, NOT_EQUAL, GREATER_THAN, GREATER_THAN_EQUAL, LESS_THAN, LESS_THAN_EQUAL, IN, CONTAINS, CONTAINS_KEY, CONTAINS_ENTRY};
        mapByFieldName = FilterOperator.buildMapByFieldName();
    }
}

