/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.google.common.collect.Sets;
import io.stargate.db.datastore.Row;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ParameterizedType;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.NameMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;

class DataTypeMapping {
    DataTypeMapping() {
    }

    static Object toDBValue(Column.ColumnType type, Object graphQLValue, NameMapping nameMapping) {
        if (type.isCollection()) {
            if (type.rawType() == Column.Type.List) {
                return DataTypeMapping.convertCollection(type, graphQLValue, nameMapping, ArrayList::new);
            }
            if (type.rawType() == Column.Type.Set) {
                return DataTypeMapping.convertCollection(type, graphQLValue, nameMapping, Sets::newLinkedHashSetWithExpectedSize);
            }
            if (type.rawType() == Column.Type.Map) {
                return DataTypeMapping.convertMap(type, graphQLValue, nameMapping);
            }
            throw new AssertionError((Object)("Invalid collection type " + type));
        }
        if (type.isUserDefined()) {
            return DataTypeMapping.convertUdt((UserDefinedType)type, graphQLValue, nameMapping);
        }
        if (type.isTuple()) {
            return DataTypeMapping.convertTuple((ParameterizedType.TupleType)type, graphQLValue, nameMapping);
        }
        return graphQLValue;
    }

    private static Collection<Object> convertCollection(Column.ColumnType type, Object graphQLvalue, NameMapping nameMapping, IntFunction<Collection<Object>> ctor) {
        Column.ColumnType elementType = (Column.ColumnType)type.parameters().get(0);
        Collection graphQLCollection = (Collection)graphQLvalue;
        Collection<Object> collection = ctor.apply(graphQLCollection.size());
        for (Object element : graphQLCollection) {
            collection.add(DataTypeMapping.toDBValue(elementType, element, nameMapping));
        }
        return collection;
    }

    private static Map<Object, Object> convertMap(Column.ColumnType type, Object graphQLValue, NameMapping nameMapping) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        Collection graphQLMap = (Collection)graphQLValue;
        Column.ColumnType keyType = (Column.ColumnType)type.parameters().get(0);
        Column.ColumnType valueType = (Column.ColumnType)type.parameters().get(1);
        for (Map entry : graphQLMap) {
            Object key = DataTypeMapping.toDBValue(keyType, entry.get("key"), nameMapping);
            Object value = DataTypeMapping.toDBValue(valueType, entry.get("value"), nameMapping);
            map.put(key, value);
        }
        return map;
    }

    private static UdtValue convertUdt(UserDefinedType type, Object graphQLValue, NameMapping nameMapping) {
        Map object = (Map)graphQLValue;
        UdtValue udt = type.create(new Object[0]);
        for (Map.Entry entry : object.entrySet()) {
            String fieldName = nameMapping.getCqlName(type, (String)entry.getKey());
            Column.ColumnType fieldType = type.fieldType(fieldName);
            Object value = DataTypeMapping.toDBValue(fieldType, entry.getValue(), nameMapping);
            udt = (UdtValue)udt.set(fieldName, value, fieldType.codec());
        }
        return udt;
    }

    private static TupleValue convertTuple(ParameterizedType.TupleType type, Object graphQLValue, NameMapping nameMapping) {
        Map object = (Map)graphQLValue;
        List subTypes = type.parameters();
        TupleValue tuple = type.create(new Object[0]);
        for (int i = 0; i < subTypes.size(); ++i) {
            Column.ColumnType subType = (Column.ColumnType)subTypes.get(i);
            Object item = object.get("item" + i);
            Object value = DataTypeMapping.toDBValue(subType, item, nameMapping);
            tuple = (TupleValue)tuple.set(i, value, subType.codec());
        }
        return tuple;
    }

    static Map<String, Object> toGraphQLValue(NameMapping nameMapping, Table table, Row row) {
        List columns = row.columns();
        HashMap<String, Object> map = new HashMap<String, Object>(columns.size());
        for (Column column : columns) {
            String graphqlName = nameMapping.getGraphqlName(table, column);
            if (graphqlName == null || row.isNull(column.name())) continue;
            map.put(graphqlName, DataTypeMapping.toGraphQLValue(nameMapping, column, row));
        }
        return map;
    }

    private static Object toGraphQLValue(NameMapping nameMapping, Column column, Row row) {
        Object dbValue = row.getObject(column.name());
        return DataTypeMapping.toGraphQLValue(nameMapping, column.type(), dbValue);
    }

    private static Object toGraphQLValue(NameMapping nameMapping, Column.ColumnType type, Object dbValue) {
        if (dbValue == null) {
            return null;
        }
        if (type.isCollection()) {
            if (type.rawType() == Column.Type.List || type.rawType() == Column.Type.Set) {
                Collection dbCollection = (Collection)dbValue;
                return dbCollection.stream().map(item -> DataTypeMapping.toGraphQLValue(nameMapping, (Column.ColumnType)type.parameters().get(0), item)).collect(Collectors.toList());
            }
            if (type.rawType() == Column.Type.Map) {
                Map dbMap = (Map)dbValue;
                Column.ColumnType keyType = (Column.ColumnType)type.parameters().get(0);
                Column.ColumnType valueType = (Column.ColumnType)type.parameters().get(1);
                return dbMap.entrySet().stream().map(e -> {
                    HashMap<String, Object> m = new HashMap<String, Object>(2);
                    m.put("key", DataTypeMapping.toGraphQLValue(nameMapping, keyType, e.getKey()));
                    m.put("value", DataTypeMapping.toGraphQLValue(nameMapping, valueType, e.getValue()));
                    return m;
                }).collect(Collectors.toList());
            }
            throw new AssertionError((Object)("Invalid collection type " + type));
        }
        if (type.isUserDefined()) {
            UserDefinedType udt = (UserDefinedType)type.frozen(false);
            UdtValue udtValue = (UdtValue)dbValue;
            HashMap<String, Object> result = new HashMap<String, Object>(udt.columns().size());
            for (Column column : udt.columns()) {
                Object dbFieldValue = udtValue.getObject(CqlIdentifier.fromInternal((String)column.name()));
                String graphQlFieldName = nameMapping.getGraphqlName(udt, column);
                if (dbFieldValue == null || graphQlFieldName == null) continue;
                Object graphQlFieldValue = DataTypeMapping.toGraphQLValue(nameMapping, column.type(), dbFieldValue);
                result.put(graphQlFieldName, graphQlFieldValue);
            }
            return result;
        }
        if (type.isTuple()) {
            TupleValue tuple = (TupleValue)dbValue;
            HashMap<String, Object> result = new HashMap<String, Object>(tuple.size());
            for (int i = 0; i < tuple.size(); ++i) {
                result.put("item" + i, DataTypeMapping.toGraphQLValue(nameMapping, (Column.ColumnType)type.parameters().get(i), tuple.getObject(i)));
            }
            return result;
        }
        return dbValue;
    }
}

