/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import com.google.common.collect.ImmutableMap;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableTable;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyspaceFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(KeyspaceFormatter.class);

    KeyspaceFormatter() {
    }

    static List<Map<String, Object>> formatResult(Set<Keyspace> keyspaces, DataFetchingEnvironment environment, AuthorizationService authorizationService, AuthenticationSubject authenticationSubject) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Keyspace keyspace : keyspaces) {
            list.add(KeyspaceFormatter.formatResult(keyspace, environment, authorizationService, authenticationSubject));
        }
        return list;
    }

    static Map<String, Object> formatResult(Keyspace keyspace, DataFetchingEnvironment environment, AuthorizationService authorizationService, AuthenticationSubject authenticationSubject) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            authorizationService.authorizeSchemaRead(authenticationSubject, Collections.singletonList(keyspace.name()), null, SourceAPI.GRAPHQL);
        }
        catch (UnauthorizedException e) {
            LOG.debug("Not returning keyspace {} due to not being authorized", (Object)keyspace.name());
            return builder.build();
        }
        builder.put((Object)"name", (Object)keyspace.name());
        KeyspaceFormatter.formatChildren((ImmutableMap.Builder<String, Object>)builder, "table", () -> ((Keyspace)keyspace).tables(), arg_0 -> ((Keyspace)keyspace).table(arg_0), KeyspaceFormatter::buildTable, environment, keyspace.name(), authorizationService, authenticationSubject);
        KeyspaceFormatter.formatChildren((ImmutableMap.Builder<String, Object>)builder, "type", () -> ((Keyspace)keyspace).userDefinedTypes(), arg_0 -> ((Keyspace)keyspace).userDefinedType(arg_0), KeyspaceFormatter::buildUdt, environment, keyspace.name(), authorizationService, authenticationSubject);
        builder.put((Object)"dcs", KeyspaceFormatter.buildDcs(keyspace));
        return builder.build();
    }

    private static <ChildT> void formatChildren(ImmutableMap.Builder<String, Object> builder, String childFieldName, Supplier<Iterable<ChildT>> allChildrenGetter, Function<String, ChildT> childByNameGetter, Function<ChildT, Map<String, Object>> converter, DataFetchingEnvironment environment, String keyspaceName, AuthorizationService authorizationService, AuthenticationSubject authenticationSubject) {
        SelectedField childField;
        String allChildrenName = childFieldName + "s";
        if (environment.getSelectionSet().getField(allChildrenName) != null) {
            ArrayList<Map<String, Object>> formattedChildren = new ArrayList<Map<String, Object>>();
            for (ChildT child : allChildrenGetter.get()) {
                if (childFieldName.equals("table")) {
                    try {
                        authorizationService.authorizeSchemaRead(authenticationSubject, Collections.singletonList(keyspaceName), Collections.singletonList(((ImmutableTable)child).name()), SourceAPI.GRAPHQL);
                    }
                    catch (UnauthorizedException e) {
                        LOG.debug("Not returning table {}.{} due to not being authorized", (Object)keyspaceName, (Object)((ImmutableTable)child).name());
                        continue;
                    }
                }
                formattedChildren.add(converter.apply(child));
            }
            builder.put((Object)allChildrenName, formattedChildren);
        }
        if ((childField = environment.getSelectionSet().getField(childFieldName)) != null) {
            ChildT child;
            String name = (String)childField.getArguments().get("name");
            if (childFieldName.equals("table")) {
                try {
                    authorizationService.authorizeSchemaRead(authenticationSubject, Collections.singletonList(keyspaceName), Collections.singletonList(name), SourceAPI.GRAPHQL);
                }
                catch (UnauthorizedException e) {
                    LOG.debug("Not returning table {}.{} due to not being authorized", (Object)keyspaceName, (Object)name);
                    return;
                }
            }
            if ((child = childByNameGetter.apply(name)) != null) {
                builder.put((Object)childFieldName, converter.apply(child));
            }
        }
    }

    private static List<Map<String, String>> buildDcs(Keyspace keyspace) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (Map.Entry entries : keyspace.replication().entrySet()) {
            if (((String)entries.getKey()).equals("class") || ((String)entries.getKey()).equals("replication_factor")) continue;
            list.add((Map<String, String>)ImmutableMap.of((Object)"name", (Object)((String)entries.getKey()), (Object)"replicas", (Object)((String)entries.getValue())));
        }
        return list;
    }

    private static Map<String, Object> buildTable(Table table) {
        return ImmutableMap.of((Object)"name", (Object)table.name(), (Object)"columns", KeyspaceFormatter.buildColumns(table.columns(), true));
    }

    private static Map<String, Object> buildUdt(UserDefinedType type) {
        return ImmutableMap.of((Object)"name", (Object)type.name(), (Object)"fields", KeyspaceFormatter.buildColumns(type.columns(), false));
    }

    private static List<Map<String, Object>> buildColumns(List<Column> columns, boolean includeKind) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Column column : columns) {
            list.add(KeyspaceFormatter.buildColumn(column, includeKind));
        }
        return list;
    }

    private static Map<String, Object> buildColumn(Column column, boolean includeKind) {
        return includeKind ? ImmutableMap.of((Object)"kind", (Object)KeyspaceFormatter.buildColumnKind(column), (Object)"name", (Object)column.name(), (Object)"type", KeyspaceFormatter.buildDataType(column.type())) : ImmutableMap.of((Object)"name", (Object)column.name(), (Object)"type", KeyspaceFormatter.buildDataType(column.type()));
    }

    private static Map<String, Object> buildDataType(Column.ColumnType columnType) {
        if (columnType.isUserDefined()) {
            return ImmutableMap.of((Object)"basic", (Object)KeyspaceFormatter.buildBasicType(columnType), (Object)"info", (Object)ImmutableMap.of((Object)"name", (Object)columnType.name(), (Object)"frozen", (Object)columnType.isFrozen()));
        }
        if (columnType.isCollection() || columnType.isTuple()) {
            return ImmutableMap.of((Object)"basic", (Object)KeyspaceFormatter.buildBasicType(columnType), (Object)"info", KeyspaceFormatter.buildParameterizedDataTypeInfo(columnType));
        }
        return ImmutableMap.of((Object)"basic", (Object)KeyspaceFormatter.buildBasicType(columnType));
    }

    private static Map<String, Object> buildParameterizedDataTypeInfo(Column.ColumnType columnType) {
        assert (columnType.isParameterized());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Column.ColumnType type : columnType.parameters()) {
            list.add(KeyspaceFormatter.buildDataType(type));
        }
        return ImmutableMap.of((Object)"subTypes", list, (Object)"frozen", (Object)columnType.isFrozen());
    }

    private static String buildBasicType(Column.ColumnType columnType) {
        return columnType.rawType().name().toUpperCase();
    }

    private static String buildColumnKind(Column column) {
        switch (column.kind()) {
            case PartitionKey: {
                return "PARTITION";
            }
            case Clustering: {
                return "CLUSTERING";
            }
            case Regular: {
                return "REGULAR";
            }
            case Static: {
                return "STATIC";
            }
        }
        return "UNKNOWN";
    }
}

