/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import graphql.Scalars;
import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class OperationModel {
    private final FieldCoordinates coordinates;

    protected OperationModel(String parentTypeName, FieldDefinition field) {
        this.coordinates = FieldCoordinates.coordinates((String)parentTypeName, (String)field.getName());
    }

    public FieldCoordinates getCoordinates() {
        return this.coordinates;
    }

    public abstract DataFetcher<?> getDataFetcher(MappingModel var1);

    public static enum SimpleReturnType implements ReturnType
    {
        BOOLEAN(Scalars.GraphQLBoolean.getName());

        private static final Map<String, SimpleReturnType> FROM_TYPE_NAME;
        private final String typeName;

        private SimpleReturnType(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public Optional<EntityModel> getEntity() {
            return Optional.empty();
        }

        @Override
        public boolean isList() {
            return false;
        }

        public static SimpleReturnType fromTypeName(String typeName) {
            return FROM_TYPE_NAME.get(typeName);
        }

        static {
            FROM_TYPE_NAME = Arrays.stream(SimpleReturnType.values()).collect(Collectors.toMap(v -> v.typeName, Function.identity()));
        }
    }

    public static class SimpleListReturnType
    implements ReturnType {
        private final SimpleReturnType simpleReturnType;

        public SimpleListReturnType(SimpleReturnType simpleReturnType) {
            this.simpleReturnType = simpleReturnType;
        }

        @Override
        public Optional<EntityModel> getEntity() {
            return Optional.empty();
        }

        @Override
        public boolean isList() {
            return true;
        }

        public SimpleReturnType getSimpleReturnType() {
            return this.simpleReturnType;
        }
    }

    public static class ResponsePayloadModelListReturnType
    extends EntityReturnTypeBase {
        private final ResponsePayloadModel responsePayloadModel;

        protected ResponsePayloadModelListReturnType(ResponsePayloadModel responsePayloadModel) {
            super(responsePayloadModel.getEntity().orElse(null));
            this.responsePayloadModel = responsePayloadModel;
        }

        public ResponsePayloadModel getResponsePayloadModel() {
            return this.responsePayloadModel;
        }

        @Override
        public boolean isList() {
            return true;
        }
    }

    public static class EntityListReturnType
    extends EntityReturnTypeBase {
        protected EntityListReturnType(EntityModel entityName) {
            super(entityName);
        }

        @Override
        public boolean isList() {
            return true;
        }
    }

    public static class EntityReturnType
    extends EntityReturnTypeBase {
        protected EntityReturnType(EntityModel entityName) {
            super(entityName);
        }

        @Override
        public boolean isList() {
            return false;
        }
    }

    public static abstract class EntityReturnTypeBase
    implements ReturnType {
        private final EntityModel entity;

        protected EntityReturnTypeBase(EntityModel entity) {
            this.entity = entity;
        }

        @Override
        public Optional<EntityModel> getEntity() {
            return Optional.of(this.entity);
        }
    }

    public static interface ReturnType {
        public Optional<EntityModel> getEntity();

        public boolean isList();
    }
}

