/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.FieldFilterInputTypeCache;
import io.stargate.graphql.schema.cqlfirst.dml.FieldInputTypeCache;
import io.stargate.graphql.schema.cqlfirst.dml.FieldOutputTypeCache;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.SchemaWarningException;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.BulkInsertMutationFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DeleteMutationFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.InsertMutationFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.QueryFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.UpdateMutationFetcher;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.aggregations.SupportedGraphqlFunction;
import io.stargate.graphql.schema.scalars.CqlScalar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmlSchemaBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DmlSchemaBuilder.class);
    private final Map<Table, GraphQLOutputType> entityResultMap = new HashMap<Table, GraphQLOutputType>();
    private final List<String> warnings = new ArrayList<String>();
    private final FieldInputTypeCache fieldInputTypes;
    private final FieldOutputTypeCache fieldOutputTypes;
    private final FieldFilterInputTypeCache fieldFilterInputTypes;
    private final NameMapping nameMapping;
    private final Keyspace keyspace;
    private static final GraphQLInputType MUTATION_OPTIONS = GraphQLInputObjectType.newInputObject().name("MutationOptions").description("The execution options for the mutation.").field(GraphQLInputObjectField.newInputObjectField().name("consistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("MutationConsistency").value("LOCAL_ONE").value("LOCAL_QUORUM").value("ALL").build()).defaultValue((Object)CassandraFetcher.DEFAULT_CONSISTENCY.toString()).build()).field(GraphQLInputObjectField.newInputObjectField().name("serialConsistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("SerialConsistency").value("SERIAL").value("LOCAL_SERIAL").build()).defaultValue((Object)CassandraFetcher.DEFAULT_SERIAL_CONSISTENCY.toString()).build()).field(GraphQLInputObjectField.newInputObjectField().name("ttl").type((GraphQLInputType)Scalars.GraphQLInt).build()).build();

    public DmlSchemaBuilder(Keyspace keyspace) {
        this.keyspace = keyspace;
        this.nameMapping = new NameMapping(keyspace.tables(), keyspace.userDefinedTypes(), this.warnings);
        this.fieldInputTypes = new FieldInputTypeCache(this.nameMapping, this.warnings);
        this.fieldOutputTypes = new FieldOutputTypeCache(this.nameMapping, this.warnings);
        this.fieldFilterInputTypes = new FieldFilterInputTypeCache(this.fieldInputTypes, this.nameMapping);
    }

    public GraphQLSchema build() {
        GraphQLSchema.Builder builder = new GraphQLSchema.Builder();
        ArrayList<GraphQLFieldDefinition> queryFields = new ArrayList<GraphQLFieldDefinition>();
        ArrayList<GraphQLFieldDefinition> mutationFields = new ArrayList<GraphQLFieldDefinition>();
        for (Table table : this.keyspace.tables()) {
            List<GraphQLFieldDefinition> tableMutationFields;
            List<GraphQLFieldDefinition> tableQueryField;
            Set<GraphQLType> additionalTypes;
            if (this.nameMapping.getGraphqlName(table) == null) continue;
            try {
                additionalTypes = this.buildTypesForTable(table);
                tableQueryField = this.buildQuery(table);
                tableMutationFields = this.buildMutations(table);
            }
            catch (Exception e) {
                this.warn(e, "Could not convert table %s, skipping", table.name());
                continue;
            }
            builder.additionalTypes(additionalTypes);
            queryFields.addAll(tableQueryField);
            mutationFields.addAll(tableMutationFields);
        }
        this.addAtomicDirective(builder);
        this.addAsyncDirective(builder);
        if (queryFields.isEmpty()) {
            GraphQLFieldDefinition emptyQueryField = GraphQLFieldDefinition.newFieldDefinition().name("keyspaceEmptyQuery").description("Placeholder query that is exposed when a keyspace is empty.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(d -> true).build();
            queryFields.add(emptyQueryField);
        }
        if (mutationFields.isEmpty()) {
            GraphQLFieldDefinition emptyMutationField = GraphQLFieldDefinition.newFieldDefinition().name("keyspaceEmptyMutation").description("Placeholder mutation that is exposed when a keyspace is empty.").type((GraphQLOutputType)Scalars.GraphQLBoolean).dataFetcher(d -> true).build();
            mutationFields.add(emptyMutationField);
        }
        queryFields.add(this.buildWarnings());
        builder.additionalType(this.buildQueryOptionsInputType());
        builder.query(this.buildQueries(queryFields));
        builder.mutation(this.buildMutationRoot(mutationFields));
        return builder.build();
    }

    private void addAtomicDirective(GraphQLSchema.Builder builder) {
        builder.additionalDirective(GraphQLDirective.newDirective().validLocation(Introspection.DirectiveLocation.MUTATION).name("atomic").description("Instructs the server to apply the mutations in a LOGGED batch").build());
    }

    private void addAsyncDirective(GraphQLSchema.Builder builder) {
        builder.additionalDirective(GraphQLDirective.newDirective().validLocation(Introspection.DirectiveLocation.MUTATION).name("async").description("Instructs the server to apply the mutations asynchronously without waiting for the result.").build());
    }

    private GraphQLObjectType buildMutationRoot(List<GraphQLFieldDefinition> mutationFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Mutation");
        for (GraphQLFieldDefinition mutation : mutationFields) {
            builder.field(mutation);
        }
        return builder.build();
    }

    private GraphQLObjectType buildQueries(List<GraphQLFieldDefinition> queryFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("Query");
        for (GraphQLFieldDefinition fieldDefinition : queryFields) {
            builder.field(fieldDefinition);
        }
        return builder.build();
    }

    private List<GraphQLFieldDefinition> buildQuery(Table table) {
        String graphqlName = this.nameMapping.getGraphqlName(table);
        GraphQLFieldDefinition query = GraphQLFieldDefinition.newFieldDefinition().name(graphqlName).description(String.format("Query for the table '%s'.%s", table.name(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLTypeReference(graphqlName + "Input"))).argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)new GraphQLTypeReference(graphqlName + "FilterInput"))).argument(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(graphqlName + "Order")))).argument(GraphQLArgument.newArgument().name("groupBy").description("The columns to group results by.").type((GraphQLInputType)new GraphQLTypeReference(graphqlName + "GroupByInput"))).argument(GraphQLArgument.newArgument().name("options").type((GraphQLInputType)new GraphQLTypeReference("QueryOptions"))).type(this.buildEntityResultOutput(table)).dataFetcher((DataFetcher)new QueryFetcher(table, this.nameMapping)).build();
        GraphQLFieldDefinition filterQuery = GraphQLFieldDefinition.newFieldDefinition().name(graphqlName + "Filter").deprecate("No longer supported. Use root type instead.").argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)new GraphQLTypeReference(graphqlName + "FilterInput"))).argument(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(graphqlName + "Order")))).argument(GraphQLArgument.newArgument().name("options").type((GraphQLInputType)new GraphQLTypeReference("QueryOptions"))).type(this.buildEntityResultOutput(table)).dataFetcher((DataFetcher)new QueryFetcher(table, this.nameMapping)).build();
        return ImmutableList.of((Object)query, (Object)filterQuery);
    }

    private List<GraphQLFieldDefinition> buildMutations(Table table) {
        ArrayList<GraphQLFieldDefinition> mutationFields = new ArrayList<GraphQLFieldDefinition>();
        mutationFields.add(this.buildDelete(table));
        mutationFields.add(this.buildInsert(table));
        mutationFields.add(this.buildBulkInsert(table));
        mutationFields.add(this.buildUpdate(table));
        return mutationFields;
    }

    private Set<GraphQLType> buildTypesForTable(Table table) {
        HashSet<GraphQLType> additionalTypes = new HashSet<GraphQLType>();
        additionalTypes.add((GraphQLType)this.buildType(table));
        additionalTypes.add(this.buildInputType(table));
        additionalTypes.add(this.buildOrderType(table));
        additionalTypes.add((GraphQLType)this.buildMutationResult(table));
        additionalTypes.add(this.buildFilterInput(table));
        additionalTypes.add(this.buildGroupByInput(table));
        return additionalTypes;
    }

    private GraphQLType buildFilterInput(Table table) {
        return GraphQLInputObjectType.newInputObject().name(this.nameMapping.getGraphqlName(table) + "FilterInput").description(this.getTypeDescription(table, DmlType.FilterInput)).fields(this.buildFilterInputFields(table)).build();
    }

    private GraphQLType buildGroupByInput(Table table) {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(this.nameMapping.getGraphqlName(table) + "GroupByInput");
        for (Column column : table.primaryKeyColumns()) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            builder.field(GraphQLInputObjectField.newInputObjectField().name(graphqlName).type((GraphQLInputType)Scalars.GraphQLBoolean).build());
        }
        return builder.build();
    }

    private GraphQLFieldDefinition buildUpdate(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("update" + this.nameMapping.getGraphqlName(table)).description(String.format("Update mutation for the table '%s'.%s", table.name(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("ifCondition").type((GraphQLInputType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type((GraphQLOutputType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "MutationResult")).dataFetcher((DataFetcher)new UpdateMutationFetcher(table, this.nameMapping)).build();
    }

    private GraphQLFieldDefinition buildBulkInsert(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("bulkInsert" + this.nameMapping.getGraphqlName(table)).description(String.format("Bulk insert mutations for the table '%s'.%s", table.name(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("values").type((GraphQLInputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "Input"))))).argument(GraphQLArgument.newArgument().name("ifNotExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "MutationResult"))).dataFetcher((DataFetcher)new BulkInsertMutationFetcher(table, this.nameMapping)).build();
    }

    private GraphQLFieldDefinition buildInsert(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("insert" + this.nameMapping.getGraphqlName(table)).description(String.format("Insert mutation for the table '%s'.%s", table.name(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifNotExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type((GraphQLOutputType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "MutationResult")).dataFetcher((DataFetcher)new InsertMutationFetcher(table, this.nameMapping)).build();
    }

    private GraphQLFieldDefinition buildDelete(Table table) {
        return GraphQLFieldDefinition.newFieldDefinition().name("delete" + this.nameMapping.getGraphqlName(table)).description(String.format("Delete mutation for the table '%s'.%s", table.name(), this.primaryKeyDescription(table))).argument(GraphQLArgument.newArgument().name("value").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "Input")))).argument(GraphQLArgument.newArgument().name("ifExists").type((GraphQLInputType)Scalars.GraphQLBoolean)).argument(GraphQLArgument.newArgument().name("ifCondition").type((GraphQLInputType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "FilterInput"))).argument(GraphQLArgument.newArgument().name("options").type(MUTATION_OPTIONS)).type((GraphQLOutputType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table) + "MutationResult")).dataFetcher((DataFetcher)new DeleteMutationFetcher(table, this.nameMapping)).build();
    }

    private List<GraphQLInputObjectField> buildFilterInputFields(Table table) {
        ArrayList<GraphQLInputObjectField> fields = new ArrayList<GraphQLInputObjectField>();
        for (Column column : table.columns()) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            try {
                fields.add(GraphQLInputObjectField.newInputObjectField().name(graphqlName).type((GraphQLInputType)this.fieldFilterInputTypes.get(column.type())).build());
            }
            catch (Exception e) {
                this.warn(e, "Could not create filter input type for column %s in table %s, skipping", column.name(), column.table());
            }
        }
        return fields;
    }

    private GraphQLOutputType buildMutationResult(Table table) {
        return GraphQLObjectType.newObject().name(this.nameMapping.getGraphqlName(table) + "MutationResult").description(this.getTypeDescription(table, DmlType.MutationOutput)).field(GraphQLFieldDefinition.newFieldDefinition().name("applied").type((GraphQLOutputType)Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("accepted").description(String.format("This field is relevant and fulfilled with data, only when used with the @%s directive", "async")).type((GraphQLOutputType)Scalars.GraphQLBoolean)).field(GraphQLFieldDefinition.newFieldDefinition().name("value").type((GraphQLOutputType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table)))).build();
    }

    private GraphQLType buildQueryOptionsInputType() {
        return GraphQLInputObjectType.newInputObject().name("QueryOptions").description("The execution options for the query.").field(GraphQLInputObjectField.newInputObjectField().name("consistency").type((GraphQLInputType)GraphQLEnumType.newEnum().name("QueryConsistency").value("LOCAL_ONE").value("LOCAL_QUORUM").value("ALL").value("SERIAL").value("LOCAL_SERIAL").build()).defaultValue((Object)CassandraFetcher.DEFAULT_CONSISTENCY.toString()).build()).field(GraphQLInputObjectField.newInputObjectField().name("limit").type((GraphQLInputType)Scalars.GraphQLInt).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageSize").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)100).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageState").type((GraphQLInputType)Scalars.GraphQLString).build()).build();
    }

    private GraphQLType buildOrderType(Table table) {
        GraphQLEnumType.Builder input = GraphQLEnumType.newEnum().name(this.nameMapping.getGraphqlName(table) + "Order").description(this.getTypeDescription(table, DmlType.Order));
        for (Column column : table.columns()) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            input.value(graphqlName + "_DESC");
            input.value(graphqlName + "_ASC");
        }
        return input.build();
    }

    private GraphQLType buildInputType(Table table) {
        GraphQLInputObjectType.Builder input = GraphQLInputObjectType.newInputObject().name(this.nameMapping.getGraphqlName(table) + "Input").description(this.getTypeDescription(table, DmlType.Input));
        for (Column column : table.columns()) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            try {
                GraphQLInputObjectField field = GraphQLInputObjectField.newInputObjectField().name(graphqlName).type((GraphQLInputType)this.fieldInputTypes.get(column.type())).build();
                input.field(field);
            }
            catch (Exception e) {
                this.warn(e, "Could not create input type for column %s in table %s, skipping", column.name(), column.table());
            }
        }
        return input.build();
    }

    private GraphQLOutputType buildEntityResultOutput(Table table) {
        if (this.entityResultMap.containsKey(table)) {
            return this.entityResultMap.get(table);
        }
        GraphQLObjectType entityResultType = GraphQLObjectType.newObject().name(this.nameMapping.getGraphqlName(table) + "Result").field(GraphQLFieldDefinition.newFieldDefinition().name("pageState").type((GraphQLOutputType)Scalars.GraphQLString)).field(GraphQLFieldDefinition.newFieldDefinition().name("values").type((GraphQLOutputType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)new GraphQLTypeReference(this.nameMapping.getGraphqlName(table)))))).build();
        this.entityResultMap.put(table, (GraphQLOutputType)entityResultType);
        return entityResultType;
    }

    public GraphQLObjectType buildType(Table table) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(this.nameMapping.getGraphqlName(table)).description(this.getTypeDescription(table, DmlType.QueryOutput));
        for (Column column : table.columns()) {
            String graphqlName = this.nameMapping.getGraphqlName(table, column);
            if (graphqlName == null) continue;
            try {
                GraphQLFieldDefinition.Builder fieldBuilder = new GraphQLFieldDefinition.Builder().name(graphqlName).type((GraphQLOutputType)this.fieldOutputTypes.get(column.type()));
                builder.field(fieldBuilder.build());
            }
            catch (Exception e) {
                this.warn(e, "Could not create output type for column %s in table %s, skipping", column.name(), column.table());
            }
        }
        this.buildAggregationFunctions(builder);
        return builder.build();
    }

    private void buildAggregationFunctions(GraphQLObjectType.Builder builder) {
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.INT_FUNCTION, Scalars.GraphQLInt));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.DOUBLE_FUNCTION, Scalars.GraphQLFloat));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.BIGINT_FUNCTION, CqlScalar.BIGINT.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.DECIMAL_FUNCTION, CqlScalar.DECIMAL.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.VARINT_FUNCTION, CqlScalar.VARINT.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.FLOAT_FUNCTION, CqlScalar.FLOAT.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.SMALLINT_FUNCTION, CqlScalar.SMALLINT.getGraphqlType()));
        builder.field(this.buildFunctionField(SupportedGraphqlFunction.TINYINT_FUNCTION, CqlScalar.TINYINT.getGraphqlType()));
    }

    private GraphQLFieldDefinition buildFunctionField(SupportedGraphqlFunction graphqlFunction, GraphQLScalarType returnType) {
        return GraphQLFieldDefinition.newFieldDefinition().name(graphqlFunction.getName()).description(String.format("Invocation of an aggregate function that returns %s.", returnType)).argument(GraphQLArgument.newArgument().name("name").description("Name of the function to invoke").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString))).argument(GraphQLArgument.newArgument().name("args").description("Arguments passed to a function. It can be a list of column names.").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString))))).type((GraphQLOutputType)returnType).build();
    }

    private GraphQLFieldDefinition buildWarnings() {
        StringBuilder description = new StringBuilder("Warnings encountered during the CQL to GraphQL conversion.");
        if (this.warnings.isEmpty()) {
            description.append("\nNo warnings found, this will return an empty list.");
        } else {
            description.append("\nThis will return:");
            for (String warning : this.warnings) {
                description.append("\n- ").append(warning);
            }
        }
        return GraphQLFieldDefinition.newFieldDefinition().name("conversionWarnings").description(description.toString()).type((GraphQLOutputType)GraphQLList.list((GraphQLType)Scalars.GraphQLString)).dataFetcher(d -> this.warnings).build();
    }

    @FormatMethod
    private void warn(Exception e, @FormatString String format, Object ... arguments) {
        String message = String.format(format, arguments);
        this.warnings.add(message + " (" + e.getMessage() + ")");
        if (!(e instanceof SchemaWarningException)) {
            LOG.warn(message, (Throwable)e);
        }
    }

    private String getTypeDescription(Table table, DmlType dmlType) {
        StringBuilder builder = new StringBuilder();
        switch (dmlType) {
            case Input: {
                builder.append("The input type");
                break;
            }
            case FilterInput: {
                builder.append("The input type used for filtering with non-equality operators");
                break;
            }
            case Order: {
                builder.append("The enum used to order a query result based on one or more fields");
                break;
            }
            case QueryOutput: {
                builder.append("The type used to represent results of a query");
                break;
            }
            case MutationOutput: {
                builder.append("The type used to represent results of a mutation");
                break;
            }
            default: {
                builder.append("Type");
            }
        }
        builder.append(" for the table '");
        builder.append(table.name());
        builder.append("'.");
        if (dmlType == DmlType.Input || dmlType == DmlType.FilterInput) {
            this.primaryKeyDescription(table, builder);
        }
        return builder.toString();
    }

    private void primaryKeyDescription(Table table, StringBuilder builder) {
        List primaryKeys = Stream.concat(table.partitionKeyColumns().stream(), table.clusteringKeyColumns().stream()).map(c -> this.nameMapping.getGraphqlName(table, (Column)c)).collect(Collectors.toList());
        builder.append("\nNote that ").append("'").append((String)primaryKeys.get(0)).append("'");
        for (int i = 1; i < primaryKeys.size(); ++i) {
            if (i == primaryKeys.size() - 1) {
                builder.append(" and ");
            } else {
                builder.append(", ");
            }
            builder.append("'").append((String)primaryKeys.get(i)).append("'");
        }
        if (primaryKeys.size() > 1) {
            builder.append(" are the fields that correspond to the table primary key.");
        } else {
            builder.append(" is the field that corresponds to the table primary key.");
        }
    }

    private String primaryKeyDescription(Table table) {
        StringBuilder builder = new StringBuilder();
        this.primaryKeyDescription(table, builder);
        return builder.toString();
    }

    private static enum DmlType {
        QueryOutput,
        MutationOutput,
        Input,
        FilterInput,
        Order;

    }
}

