/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql;

import com.codahale.metrics.health.HealthCheckRegistry;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.core.activator.BaseActivator;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.graphql.web.DropwizardServer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlActivator
extends BaseActivator {
    public static final String MODULE_NAME = "graphqlapi";
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlActivator.class);
    private static final String AUTH_IDENTIFIER = System.getProperty("stargate.auth_id", "AuthTableBasedService");
    private static final boolean ENABLE_GRAPHQL_FIRST = Boolean.parseBoolean(System.getProperty("stargate.graphql_first.enabled", "true"));
    private static final boolean ENABLE_GRAPHQL_PLAYGROUND = !Boolean.getBoolean("stargate.graphql_playground.disabled");
    private BaseActivator.ServicePointer<AuthenticationService> authentication = BaseActivator.ServicePointer.create(AuthenticationService.class, (String)"AuthIdentifier", (String)AUTH_IDENTIFIER);
    private BaseActivator.ServicePointer<AuthorizationService> authorization = BaseActivator.ServicePointer.create(AuthorizationService.class, (String)"AuthIdentifier", (String)AUTH_IDENTIFIER);
    private BaseActivator.ServicePointer<Persistence> persistence = BaseActivator.ServicePointer.create(Persistence.class, (String)"Identifier", (String)"StargatePersistence");
    private BaseActivator.ServicePointer<Metrics> metrics = BaseActivator.ServicePointer.create(Metrics.class);
    private BaseActivator.ServicePointer<HttpMetricsTagProvider> httpTagProvider = BaseActivator.ServicePointer.create(HttpMetricsTagProvider.class);
    private final BaseActivator.ServicePointer<HealthCheckRegistry> healthCheckRegistry = BaseActivator.ServicePointer.create(HealthCheckRegistry.class);
    private final BaseActivator.ServicePointer<DataStoreFactory> dataStoreFactory = BaseActivator.ServicePointer.create(DataStoreFactory.class);
    @GuardedBy(value="this")
    private DropwizardServer server;

    public GraphqlActivator() {
        super("GraphQL", true);
    }

    @Nullable
    protected BaseActivator.ServiceAndProperties createService() {
        this.maybeStartService();
        return null;
    }

    protected void stopService() {
        this.maybeStopService();
    }

    protected List<BaseActivator.ServicePointer<?>> dependencies() {
        return Arrays.asList(this.persistence, this.metrics, this.httpTagProvider, this.healthCheckRegistry, this.authentication, this.authorization, this.dataStoreFactory);
    }

    private synchronized void maybeStartService() {
        if (this.server == null) {
            try {
                this.server = new DropwizardServer((Persistence)this.persistence.get(), (AuthenticationService)this.authentication.get(), (AuthorizationService)this.authorization.get(), (Metrics)this.metrics.get(), (HttpMetricsTagProvider)this.httpTagProvider.get(), (DataStoreFactory)this.dataStoreFactory.get(), ENABLE_GRAPHQL_FIRST, ENABLE_GRAPHQL_PLAYGROUND);
                LOG.info("Starting GraphQL");
                this.server.run("server", "config.yaml");
            }
            catch (Exception e) {
                LOG.error("Unexpected error while stopping GraphQL", (Throwable)e);
            }
        }
    }

    private synchronized void maybeStopService() {
        if (this.server != null) {
            try {
                LOG.info("Stopping GraphQL");
                this.server.stop();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while stopping GraphQL", (Throwable)e);
            }
        }
    }
}

