/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.fetchers.admin;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.schema.graphqlfirst.fetchers.admin.DeploySchemaResponseDto;
import io.stargate.graphql.schema.graphqlfirst.migration.CassandraMigrator;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationQuery;
import io.stargate.graphql.schema.graphqlfirst.migration.MigrationStrategy;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessedSchema;
import io.stargate.graphql.schema.graphqlfirst.processor.SchemaProcessor;
import io.stargate.graphql.web.StargateGraphqlContext;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

abstract class DeploySchemaFetcherBase
extends CassandraFetcher<DeploySchemaResponseDto> {
    DeploySchemaFetcherBase() {
    }

    @Override
    protected DeploySchemaResponseDto get(DataFetchingEnvironment environment, StargateGraphqlContext context) throws Exception {
        List<MigrationQuery> queries;
        ProcessedSchema processedSchema;
        SchemaSourceDao schemaSourceDao = new SchemaSourceDao(context.getDataStore());
        String keyspaceName = (String)environment.getArgument("keyspace");
        Keyspace keyspace = context.getDataStore().schema().keyspace(keyspaceName);
        if (keyspace == null) {
            throw new IllegalArgumentException("Keyspace '%s' does not exist.");
        }
        context.getAuthorizationService().authorizeDataWrite(context.getSubject(), "stargate_graphql", "schema_source", Scope.MODIFY, SourceAPI.GRAPHQL);
        String input = this.getSchemaContents(environment);
        UUID expectedVersion = this.getExpectedVersion(environment);
        MigrationStrategy migrationStrategy = (MigrationStrategy)((Object)environment.getArgument("migrationStrategy"));
        boolean force = (Boolean)environment.getArgument("force");
        boolean dryRun = (Boolean)environment.getArgument("dryRun");
        if (!dryRun) {
            schemaSourceDao.startDeployment(keyspaceName, expectedVersion, force);
        }
        DeploySchemaResponseDto response = new DeploySchemaResponseDto();
        try {
            processedSchema = new SchemaProcessor(context.getPersistence(), false).process(input, keyspace);
            response.setLogs(processedSchema.getLogs());
            queries = CassandraMigrator.forDeployment(migrationStrategy).compute(processedSchema.getMappingModel(), keyspace);
            for (MigrationQuery query : queries) {
                query.authorize(context.getAuthorizationService(), context.getSubject());
            }
            response.setCqlChanges(queries);
        }
        catch (Exception e) {
            if (!dryRun) {
                schemaSourceDao.abortDeployment(keyspaceName);
            }
            throw e;
        }
        if (!dryRun) {
            for (MigrationQuery query : queries) {
                context.getDataStore().execute(query.build(context.getDataStore())).get();
            }
            SchemaSource newSource = schemaSourceDao.insert(keyspaceName, input);
            schemaSourceDao.purgeOldVersions(keyspaceName);
            response.setVersion(newSource.getVersion());
            context.getGraphqlCache().putDml(keyspaceName, newSource, processedSchema.getGraphql(), context.getSubject());
        }
        return response;
    }

    protected abstract String getSchemaContents(DataFetchingEnvironment var1) throws IOException;

    private UUID getExpectedVersion(DataFetchingEnvironment environment) {
        UUID expectedVersion;
        String expectedVersionSpec = (String)environment.getArgument("expectedVersion");
        try {
            expectedVersion = expectedVersionSpec == null ? null : UUID.fromString(expectedVersionSpec);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid 'expectedVersion' value.");
        }
        return expectedVersion;
    }
}

