/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.graphql.schema.cqlfirst.dml.FieldTypeCache;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.SchemaWarningException;
import io.stargate.graphql.schema.cqlfirst.dml.types.MapBuilder;
import io.stargate.graphql.schema.cqlfirst.dml.types.TupleBuilder;
import java.util.List;
import java.util.stream.Collectors;

class FieldOutputTypeCache
extends FieldTypeCache<GraphQLOutputType> {
    private final List<String> warnings;

    FieldOutputTypeCache(NameMapping nameMapping, List<String> warnings) {
        super(nameMapping);
        this.warnings = warnings;
    }

    @Override
    protected GraphQLOutputType compute(Column.ColumnType columnType) {
        if (columnType.isMap()) {
            GraphQLType keyType = (GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(0));
            GraphQLType valueType = (GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(1));
            return new MapBuilder(keyType, valueType, false).build();
        }
        if (columnType.isList() || columnType.isSet()) {
            return new GraphQLList((GraphQLType)this.get((Column.ColumnType)columnType.parameters().get(0)));
        }
        if (columnType.isUserDefined()) {
            UserDefinedType udt = (UserDefinedType)columnType;
            return this.computeUdt(udt);
        }
        if (columnType.isTuple()) {
            List<GraphQLType> subTypes = columnType.parameters().stream().map(this::get).collect(Collectors.toList());
            return new TupleBuilder(subTypes).buildOutputType();
        }
        return this.getScalar(columnType.rawType());
    }

    private GraphQLOutputType computeUdt(UserDefinedType udt) {
        String graphqlName = this.nameMapping.getGraphqlName(udt);
        if (graphqlName == null) {
            throw new SchemaWarningException(String.format("Could not find a GraphQL name mapping for UDT %s, this is probably because it clashes with another UDT", udt.name()));
        }
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(graphqlName);
        for (Column column : udt.columns()) {
            String graphqlFieldName = this.nameMapping.getGraphqlName(udt, column);
            if (graphqlFieldName == null) continue;
            try {
                builder.field(new GraphQLFieldDefinition.Builder().name(graphqlFieldName).type((GraphQLOutputType)this.get(column.type())).build());
            }
            catch (Exception e) {
                this.warnings.add(String.format("Could not create output type for field %s in UDT %s, skipping (%s)", column.name(), column.table(), e.getMessage()));
            }
        }
        return builder.build();
    }
}

