/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import graphql.ExecutionInput;
import graphql.GraphQL;
import io.stargate.graphql.web.HttpAwareContext;
import io.stargate.graphql.web.models.GraphqlJsonBody;
import io.stargate.graphql.web.resources.GraphqlDdlResource;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class GraphqlResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlDdlResource.class);
    protected static final String APPLICATION_GRAPHQL = "application/graphql";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    protected static void get(String query, String operationName, String variables, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse) {
        if (Strings.isNullOrEmpty((String)query)) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query as a URL parameter", asyncResponse);
            return;
        }
        try {
            ExecutionInput.Builder input = ExecutionInput.newExecutionInput((String)query).operationName(operationName).context((Object)new HttpAwareContext(httpRequest));
            if (!Strings.isNullOrEmpty((String)variables)) {
                Map parsedVariables = (Map)OBJECT_MAPPER.readValue(variables, Map.class);
                input = input.variables(parsedVariables);
            }
            GraphqlResourceBase.executeAsync(input.build(), graphql, asyncResponse);
        }
        catch (IOException e) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "Could not parse variables: " + e.getMessage(), asyncResponse);
        }
    }

    protected static void postJson(GraphqlJsonBody jsonBody, @QueryParam(value="query") String queryFromUrl, GraphQL graphql, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        Map<String, Object> variables;
        queryFromUrl = Strings.emptyToNull((String)queryFromUrl);
        String queryFromBody = jsonBody == null ? null : Strings.emptyToNull((String)jsonBody.getQuery());
        String operationName = jsonBody == null ? null : Strings.emptyToNull((String)jsonBody.getOperationName());
        Map<String, Object> map = variables = jsonBody == null ? null : jsonBody.getVariables();
        if (queryFromBody == null && queryFromUrl == null) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query, either as a query parameter or in the request body", asyncResponse);
            return;
        }
        if (queryFromBody != null && queryFromUrl != null) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "You can't provide a GraphQL query both as a query parameter and in the request body", asyncResponse);
            return;
        }
        String query = (String)MoreObjects.firstNonNull((Object)queryFromBody, (Object)queryFromUrl);
        ExecutionInput.Builder input = ExecutionInput.newExecutionInput((String)query).operationName(operationName).context((Object)new HttpAwareContext(httpRequest));
        if (variables != null) {
            input = input.variables(variables);
        }
        GraphqlResourceBase.executeAsync(input.build(), graphql, asyncResponse);
    }

    protected static void postGraphql(String query, GraphQL graphql, @Context HttpServletRequest httpRequest, @Suspended AsyncResponse asyncResponse) {
        if (Strings.isNullOrEmpty((String)query)) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query in the request body", asyncResponse);
            return;
        }
        ExecutionInput input = ExecutionInput.newExecutionInput((String)query).context((Object)new HttpAwareContext(httpRequest)).build();
        GraphqlResourceBase.executeAsync(input, graphql, asyncResponse);
    }

    protected static void executeAsync(ExecutionInput input, GraphQL graphql, @Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)graphql.executeAsync(input).thenApply(result -> asyncResponse.resume((Object)result.toSpecification()))).exceptionally(error -> {
            LOG.error("Unexpected error while processing GraphQL request", error);
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.INTERNAL_SERVER_ERROR, "Internal server error", asyncResponse);
            return null;
        });
    }

    protected static void replyWithGraphqlError(Response.Status status, String message, @Suspended AsyncResponse asyncResponse) {
        asyncResponse.resume((Object)Response.status((Response.Status)status).entity((Object)ImmutableMap.of((Object)"errors", (Object)ImmutableList.of((Object)message))).build());
    }
}

