/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.dml;

import com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.TypedKeyValue;
import io.stargate.core.util.ByteBufferUtils;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.BoundSelect;
import io.stargate.db.query.builder.ColumnOrder;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.NameMapping;
import io.stargate.graphql.schema.fetchers.dml.DataTypeMapping;
import io.stargate.graphql.schema.fetchers.dml.DmlFetcher;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryFetcher
extends DmlFetcher<Map<String, Object>> {
    public QueryFetcher(Table table, NameMapping nameMapping, AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(table, nameMapping, authenticationService, authorizationService, dataStoreFactory);
    }

    @Override
    protected Map<String, Object> get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) throws Exception {
        BoundQuery query = this.buildQuery(environment, dataStore);
        ResultSet resultSet = this.authorizationService.authorizedDataRead(() -> (ResultSet)dataStore.execute(query).get(), authenticationSubject, this.table.keyspace(), this.table.name(), TypedKeyValue.forSelect((BoundSelect)((BoundSelect)query)), SourceAPI.GRAPHQL);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("values", resultSet.currentPageRows().stream().map(row -> DataTypeMapping.toGraphQLValue(this.nameMapping, this.table, row)).collect(Collectors.toList()));
        ByteBuffer pageState = resultSet.getPagingState();
        if (pageState != null) {
            result.put("pageState", ByteBufferUtils.toBase64((ByteBuffer)pageState));
        }
        return result;
    }

    private BoundQuery buildQuery(DataFetchingEnvironment environment, DataStore dataStore) {
        Long limit = null;
        if (environment.containsArgument("options")) {
            Object limitObj;
            Map options = (Map)environment.getArgument("options");
            Object v0 = limitObj = options == null ? null : options.get("limit");
            if (limitObj != null) {
                limit = limitObj;
            }
        }
        return dataStore.queryBuilder().select().column(this.buildQueryColumns(environment)).from(this.table.keyspace(), this.table.name()).where(this.buildClause(this.table, environment)).limit(limit).orderBy(this.buildOrderBy(environment)).build().bind(new Object[0]);
    }

    private List<ColumnOrder> buildOrderBy(DataFetchingEnvironment environment) {
        if (environment.containsArgument("orderBy")) {
            ArrayList<ColumnOrder> orderBy = new ArrayList<ColumnOrder>();
            List orderList = (List)environment.getArgument("orderBy");
            for (String order : orderList) {
                int split = order.lastIndexOf("_");
                String column = order.substring(0, split);
                boolean desc = order.substring(split + 1).equals("DESC");
                orderBy.add(ColumnOrder.of((String)this.getDBColumnName(this.table, column), (Column.Order)(desc ? Column.Order.DESC : Column.Order.ASC)));
            }
            return orderBy;
        }
        return ImmutableList.of();
    }

    private List<Column> buildQueryColumns(DataFetchingEnvironment environment) {
        if (environment.getSelectionSet().contains("values")) {
            SelectedField field = environment.getSelectionSet().getField("values");
            ArrayList<Column> fields = new ArrayList<Column>();
            for (SelectedField selectedField : field.getSelectionSet().getFields()) {
                String column;
                if ("__typename".equals(selectedField.getName()) || (column = this.getDBColumnName(this.table, selectedField.getName())) == null) continue;
                fields.add(Column.reference((String)column));
            }
            return fields;
        }
        return ImmutableList.of();
    }
}

