/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.Scope;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.query.Query;
import io.stargate.db.query.builder.QueryBuilder;
import io.stargate.graphql.schema.fetchers.ddl.AlterTableAddFetcher;
import io.stargate.graphql.schema.fetchers.ddl.AlterTableDropFetcher;
import io.stargate.graphql.schema.fetchers.ddl.CreateTableFetcher;
import io.stargate.graphql.schema.fetchers.ddl.DdlQueryFetcher;
import io.stargate.graphql.schema.fetchers.ddl.DropTableFetcher;

public abstract class TableFetcher
extends DdlQueryFetcher {
    protected TableFetcher(AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authenticationService, authorizationService, dataStoreFactory);
    }

    @Override
    protected Query<?> buildQuery(DataFetchingEnvironment dataFetchingEnvironment, QueryBuilder builder, AuthenticationSubject authenticationSubject) throws UnauthorizedException {
        String keyspaceName = (String)dataFetchingEnvironment.getArgument("keyspaceName");
        String tableName = (String)dataFetchingEnvironment.getArgument("tableName");
        Scope scope = null;
        if (this instanceof AlterTableAddFetcher || this instanceof AlterTableDropFetcher) {
            scope = Scope.ALTER;
        } else if (this instanceof CreateTableFetcher) {
            scope = Scope.CREATE;
        } else if (this instanceof DropTableFetcher) {
            scope = Scope.DROP;
        }
        this.authorizationService.authorizeSchemaWrite(authenticationSubject, keyspaceName, tableName, scope, SourceAPI.GRAPHQL);
        return this.buildQuery(dataFetchingEnvironment, builder, keyspaceName, tableName);
    }

    protected abstract Query<?> buildQuery(DataFetchingEnvironment var1, QueryBuilder var2, String var3, String var4);
}

