/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers.ddl;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.schema.Keyspace;
import io.stargate.graphql.schema.fetchers.CassandraFetcher;
import io.stargate.graphql.schema.fetchers.ddl.KeyspaceFormatter;
import java.util.Map;

public class SingleKeyspaceFetcher
extends CassandraFetcher<Map<String, Object>> {
    public SingleKeyspaceFetcher(AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        super(authenticationService, authorizationService, dataStoreFactory);
    }

    @Override
    protected Map<String, Object> get(DataFetchingEnvironment environment, DataStore dataStore, AuthenticationSubject authenticationSubject) {
        String keyspaceName = (String)environment.getArgument("name");
        Keyspace keyspace = dataStore.schema().keyspace(keyspaceName);
        if (keyspace == null) {
            return null;
        }
        return KeyspaceFormatter.formatResult(keyspace, environment, this.authorizationService, authenticationSubject);
    }
}

