/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.fetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.ImmutableParameters;
import io.stargate.db.Parameters;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.db.datastore.DataStoreOptions;
import io.stargate.db.datastore.ImmutableDataStoreOptions;
import io.stargate.graphql.web.HttpAwareContext;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import org.apache.cassandra.stargate.db.ConsistencyLevel;

public abstract class CassandraFetcher<ResultT>
implements DataFetcher<ResultT> {
    protected final AuthenticationService authenticationService;
    protected final AuthorizationService authorizationService;
    private final DataStoreFactory dataStoreFactory;
    public static final ConsistencyLevel DEFAULT_CONSISTENCY = ConsistencyLevel.LOCAL_QUORUM;
    public static final ConsistencyLevel DEFAULT_SERIAL_CONSISTENCY = ConsistencyLevel.SERIAL;
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final Parameters DEFAULT_PARAMETERS = Parameters.builder().pageSize(100).consistencyLevel(DEFAULT_CONSISTENCY).serialConsistencyLevel(DEFAULT_SERIAL_CONSISTENCY).build();

    public CassandraFetcher(AuthenticationService authenticationService, AuthorizationService authorizationService, DataStoreFactory dataStoreFactory) {
        this.authenticationService = authenticationService;
        this.authorizationService = authorizationService;
        this.dataStoreFactory = dataStoreFactory;
    }

    public final ResultT get(DataFetchingEnvironment environment) throws Exception {
        Parameters parameters;
        HttpAwareContext httpAwareContext = (HttpAwareContext)environment.getContext();
        String token = httpAwareContext.getAuthToken();
        AuthenticationSubject authenticationSubject = this.authenticationService.validateToken(token, httpAwareContext.getAllHeaders());
        Map options = (Map)environment.getArgument("options");
        if (options != null) {
            Object pageState;
            Object pageSize;
            Object serialConsistency;
            ImmutableParameters.Builder builder = Parameters.builder().from(DEFAULT_PARAMETERS);
            Object consistency = options.get("consistency");
            if (consistency != null) {
                builder.consistencyLevel(ConsistencyLevel.valueOf((String)((String)consistency)));
            }
            if ((serialConsistency = options.get("serialConsistency")) != null) {
                builder.serialConsistencyLevel(ConsistencyLevel.valueOf((String)((String)serialConsistency)));
            }
            if ((pageSize = options.get("pageSize")) != null) {
                builder.pageSize(((Integer)pageSize).intValue());
            }
            if ((pageState = options.get("pageState")) != null) {
                builder.pagingState(ByteBuffer.wrap(Base64.getDecoder().decode((String)pageState)));
            }
            parameters = builder.build();
        } else {
            parameters = DEFAULT_PARAMETERS;
        }
        ImmutableDataStoreOptions dataStoreOptions = DataStoreOptions.builder().defaultParameters(parameters).alwaysPrepareQueries(true).build();
        DataStore dataStore = this.dataStoreFactory.create(authenticationSubject.roleName(), authenticationSubject.isFromExternalAuth(), (DataStoreOptions)dataStoreOptions);
        return this.get(environment, dataStore, authenticationSubject);
    }

    protected abstract ResultT get(DataFetchingEnvironment var1, DataStore var2, AuthenticationSubject var3) throws Exception;
}

