/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml;

import graphql.Scalars;
import graphql.schema.GraphQLScalarType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableListType;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.scalars.CqlScalar;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
abstract class FieldTypeCache<GraphqlT> {
    protected final NameMapping nameMapping;
    private final Map<Column.ColumnType, GraphqlT> types = new HashMap<Column.ColumnType, GraphqlT>();

    FieldTypeCache(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    GraphqlT get(Column.ColumnType type) {
        type = this.normalize(type);
        return this.computeIfAbsent(type);
    }

    private GraphqlT computeIfAbsent(Column.ColumnType type) {
        GraphqlT result = this.types.get(type);
        if (result == null) {
            result = this.compute(type);
            this.types.put(type, result);
        }
        return result;
    }

    private Column.ColumnType normalize(Column.ColumnType type) {
        if ((type = type.frozen(false)).isSet()) {
            type = ImmutableListType.builder().addAllParameters((Iterable)type.parameters()).build();
        }
        if (type == Column.Type.Varchar) {
            type = Column.Type.Text;
        }
        return type;
    }

    protected abstract GraphqlT compute(Column.ColumnType var1);

    protected GraphQLScalarType getScalar(Column.Type type) {
        switch (type) {
            case Boolean: {
                return Scalars.GraphQLBoolean;
            }
            case Double: {
                return Scalars.GraphQLFloat;
            }
            case Int: {
                return Scalars.GraphQLInt;
            }
            case Text: 
            case Varchar: {
                return Scalars.GraphQLString;
            }
        }
        return CqlScalar.fromCqlType(type).orElseThrow(() -> new IllegalArgumentException("Unsupported CQL type " + type)).getGraphqlType();
    }
}

