/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.cqlfirst.dml.fetchers.aggregations;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.builder.QueryBuilderImpl;
import io.stargate.db.schema.Table;
import io.stargate.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.DbColumnGetter;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.aggregations.SupportedAggregationFunction;
import io.stargate.graphql.schema.cqlfirst.dml.fetchers.aggregations.SupportedGraphqlFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class AggregationsFetcherSupport {
    private final Table table;
    private final DbColumnGetter dbColumnGetter;

    public AggregationsFetcherSupport(NameMapping nameMapping, Table table) {
        this.table = table;
        this.dbColumnGetter = new DbColumnGetter(nameMapping);
    }

    public List<QueryBuilderImpl.FunctionCall> buildAggregatedFunctions(DataFetchingEnvironment environment) {
        List valuesFields = environment.getSelectionSet().getFields("values", new String[0]);
        if (valuesFields.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueryBuilderImpl.FunctionCall> functionCalls = new ArrayList<QueryBuilderImpl.FunctionCall>();
        for (SelectedField selectedField : this.extractAllFieldsAndDeduplicate(valuesFields)) {
            Map arguments = selectedField.getArguments();
            this.getSupportedFunction(arguments).ifPresent(f -> {
                switch (f) {
                    case COUNT: {
                        functionCalls.add(this.createAggregationFunctionCall(arguments, QueryBuilderImpl.FunctionCall::count, selectedField, SupportedAggregationFunction.COUNT));
                        break;
                    }
                    case AVG: {
                        functionCalls.add(this.createAggregationFunctionCall(arguments, QueryBuilderImpl.FunctionCall::avg, selectedField, SupportedAggregationFunction.AVG));
                        break;
                    }
                    case MIN: {
                        functionCalls.add(this.createAggregationFunctionCall(arguments, QueryBuilderImpl.FunctionCall::min, selectedField, SupportedAggregationFunction.MIN));
                        break;
                    }
                    case MAX: {
                        functionCalls.add(this.createAggregationFunctionCall(arguments, QueryBuilderImpl.FunctionCall::max, selectedField, SupportedAggregationFunction.MAX));
                        break;
                    }
                    case SUM: {
                        functionCalls.add(this.createAggregationFunctionCall(arguments, QueryBuilderImpl.FunctionCall::sum, selectedField, SupportedAggregationFunction.SUM));
                    }
                }
            });
        }
        return functionCalls;
    }

    public Map<String, Object> addAggregationResults(Map<String, Object> columns, DataFetchingEnvironment environment, Row row) {
        List valuesFields = environment.getSelectionSet().getFields("values", new String[0]);
        if (valuesFields.isEmpty()) {
            return columns;
        }
        for (SelectedField selectedField : this.extractAllFieldsAndDeduplicate(valuesFields)) {
            SupportedGraphqlFunction.valueOfIgnoreCase(selectedField.getName()).ifPresent(f -> this.putResultValue(columns, row, selectedField, f.getRowValueExtractor()));
        }
        return columns;
    }

    private void putResultValue(Map<String, Object> columns, Row row, SelectedField selectedField, BiFunction<Row, String, Object> rowValueExtractor) {
        String alias = selectedField.getAlias();
        if (alias != null) {
            columns.put(selectedField.getName(), rowValueExtractor.apply(row, alias));
        } else {
            String columnName = this.generateAggregationColumnName(selectedField);
            columns.put(selectedField.getName(), rowValueExtractor.apply(row, columnName));
        }
    }

    private String generateAggregationColumnName(SelectedField selectedField) {
        Map arguments = selectedField.getArguments();
        Optional<SupportedAggregationFunction> functionName = this.getSupportedFunction(arguments);
        if (!functionName.isPresent()) {
            throw new IllegalStateException(String.format("The function for arguments: %s does not exists.", arguments));
        }
        List<String> args = this.getAndValidateArgs(arguments, functionName.get());
        return String.format("system.%s(%s)", functionName.get().getName(), args.get(0));
    }

    private QueryBuilderImpl.FunctionCall createAggregationFunctionCall(Map<String, Object> arguments, BiFunction<String, String, QueryBuilderImpl.FunctionCall> addAggregation, SelectedField selectedField, SupportedAggregationFunction supportedAggregationFunction) {
        List<String> args = this.getAndValidateArgs(arguments, supportedAggregationFunction);
        String column = this.getAndValidateColumn(args, supportedAggregationFunction);
        String alias = selectedField.getAlias();
        return addAggregation.apply(column, alias);
    }

    private String getAndValidateColumn(List<String> args, SupportedAggregationFunction supportedAggregationFunction) {
        String column = this.dbColumnGetter.getDBColumnName(this.table, args.get(0));
        if (column == null) {
            throw new IllegalArgumentException(String.format("The column name: %s provided for the %s function does not exists.", args.get(0), supportedAggregationFunction.getName()));
        }
        return column;
    }

    private List<String> getAndValidateArgs(Map<String, Object> arguments, SupportedAggregationFunction supportedAggregationFunction) {
        List args = (List)arguments.get("args");
        if (args.size() != 1) {
            throw new IllegalArgumentException(String.format("The %s function takes only one argument, but more arguments: %s were provided.", supportedAggregationFunction.getName(), args));
        }
        return args;
    }

    private Optional<SupportedAggregationFunction> getSupportedFunction(Map<String, Object> arguments) {
        return SupportedAggregationFunction.valueOfIgnoreCase((String)arguments.get("name"));
    }

    private Set<SelectedField> extractAllFieldsAndDeduplicate(List<SelectedField> valuesFields) {
        return valuesFields.stream().flatMap(v -> v.getSelectionSet().getFields().stream()).collect(Collectors.toSet());
    }
}

