/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.GraphqlErrorException;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.auth.SourceAPI;
import io.stargate.auth.UnauthorizedException;
import io.stargate.auth.entity.ResourceKind;
import io.stargate.db.Persistence;
import io.stargate.graphql.web.StargateGraphqlContext;
import io.stargate.graphql.web.models.GraphqlJsonBody;
import io.stargate.graphql.web.resources.AuthenticationFilter;
import io.stargate.graphql.web.resources.DdlResource;
import io.stargate.graphql.web.resources.GraphqlCache;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class GraphqlResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(DdlResource.class);
    protected static final String APPLICATION_GRAPHQL = "application/graphql";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, List<String>>> FILES_MAPPING_TYPE = new TypeReference<Map<String, List<String>>>(){};
    private static final Splitter PATH_SPLITTER = Splitter.on((String)".");
    @Inject
    protected AuthorizationService authorizationService;
    @Inject
    protected Persistence persistence;
    @Inject
    protected GraphqlCache graphqlCache;

    protected void get(String query, String operationName, String variables, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse) {
        if (Strings.isNullOrEmpty((String)query)) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query as a URL parameter", asyncResponse);
            return;
        }
        try {
            ExecutionInput.Builder input = ExecutionInput.newExecutionInput((String)query).operationName(operationName).context((Object)new StargateGraphqlContext(httpRequest, this.authorizationService, this.persistence, this.graphqlCache));
            if (!Strings.isNullOrEmpty((String)variables)) {
                Map parsedVariables = (Map)OBJECT_MAPPER.readValue(variables, Map.class);
                input = input.variables(parsedVariables);
            }
            GraphqlResourceBase.executeAsync(input.build(), graphql, asyncResponse);
        }
        catch (IOException e) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "Could not parse variables: " + e.getMessage(), asyncResponse);
        }
    }

    protected void postJson(GraphqlJsonBody jsonBody, String queryFromUrl, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse) {
        Map<String, Object> variables;
        queryFromUrl = Strings.emptyToNull((String)queryFromUrl);
        String queryFromBody = jsonBody == null ? null : Strings.emptyToNull((String)jsonBody.getQuery());
        String operationName = jsonBody == null ? null : Strings.emptyToNull((String)jsonBody.getOperationName());
        Map<String, Object> map = variables = jsonBody == null ? null : jsonBody.getVariables();
        if (queryFromBody == null && queryFromUrl == null) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query, either as a query parameter or in the request body", asyncResponse);
            return;
        }
        if (queryFromBody != null && queryFromUrl != null) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "You can't provide a GraphQL query both as a query parameter and in the request body", asyncResponse);
            return;
        }
        String query = (String)MoreObjects.firstNonNull((Object)queryFromBody, (Object)queryFromUrl);
        ExecutionInput.Builder input = ExecutionInput.newExecutionInput((String)query).operationName(operationName).context((Object)new StargateGraphqlContext(httpRequest, this.authorizationService, this.persistence, this.graphqlCache));
        if (variables != null) {
            input = input.variables(variables);
        }
        GraphqlResourceBase.executeAsync(input.build(), graphql, asyncResponse);
    }

    protected void postMultipartJson(GraphqlJsonBody jsonBody, FormDataMultiPart allParts, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse) {
        if (jsonBody == null) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "Could not find GraphQL operations object. Make sure your multipart request includes an 'operations' part with MIME type application/json", asyncResponse);
            return;
        }
        if (GraphqlResourceBase.bindFilesToVariables(jsonBody, allParts, asyncResponse)) {
            this.postJson(jsonBody, null, graphql, httpRequest, asyncResponse);
        }
    }

    private static boolean bindFilesToVariables(GraphqlJsonBody jsonBody, FormDataMultiPart allParts, AsyncResponse asyncResponse) {
        Map<String, Object> variables = jsonBody.getVariables();
        FormDataBodyPart filesMappingPart = allParts.getField("map");
        if (filesMappingPart != null) {
            Map filesMapping;
            if (variables == null || variables.isEmpty()) {
                GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "Found a 'map' part but the GraphQL query has no variables", asyncResponse);
                return false;
            }
            try {
                filesMapping = (Map)OBJECT_MAPPER.readValue(filesMappingPart.getValue(), FILES_MAPPING_TYPE);
            }
            catch (JsonProcessingException e) {
                GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "Could not parse map part: " + e.getMessage(), asyncResponse);
                return false;
            }
            for (Map.Entry entry : filesMapping.entrySet()) {
                String partName = (String)entry.getKey();
                List variablePaths = (List)entry.getValue();
                FormDataBodyPart part = allParts.getField(partName);
                if (part == null) {
                    GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, String.format("The 'map' part references '%s', but found no part with that name", partName), asyncResponse);
                    return false;
                }
                if (variablePaths == null || variablePaths.size() != 1) {
                    GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, String.format("This implementation only allows file parts to reference exactly one variable (offending part: '%s' with %d variables)", partName, variablePaths == null ? 0 : variablePaths.size()), asyncResponse);
                    return false;
                }
                String variablePath = (String)variablePaths.get(0);
                List pathElements = PATH_SPLITTER.splitToList((CharSequence)variablePath);
                if (pathElements.size() != 2 && !"variables".equals(pathElements.get(0))) {
                    GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, String.format("This implementation only allows simple variable references like 'variables.x' (offending reference: '%s')", variablePath), asyncResponse);
                    return false;
                }
                String variableName = (String)pathElements.get(1);
                variables.put(variableName, part.getEntityAs(InputStream.class));
            }
        }
        return true;
    }

    protected void postGraphql(String query, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse) {
        if (Strings.isNullOrEmpty((String)query)) {
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query in the request body", asyncResponse);
            return;
        }
        ExecutionInput input = ExecutionInput.newExecutionInput((String)query).context((Object)new StargateGraphqlContext(httpRequest, this.authorizationService, this.persistence, this.graphqlCache)).build();
        GraphqlResourceBase.executeAsync(input, graphql, asyncResponse);
    }

    protected static void executeAsync(ExecutionInput input, GraphQL graphql, @Suspended AsyncResponse asyncResponse) {
        ((CompletableFuture)graphql.executeAsync(input).thenApply(result -> asyncResponse.resume((Object)result.toSpecification()))).exceptionally(error -> {
            LOG.error("Unexpected error while processing GraphQL request", error);
            GraphqlResourceBase.replyWithGraphqlError(Response.Status.INTERNAL_SERVER_ERROR, "Internal server error", asyncResponse);
            return null;
        });
    }

    protected boolean isAuthorized(HttpServletRequest httpRequest, String keyspaceName) {
        AuthenticationSubject subject = (AuthenticationSubject)httpRequest.getAttribute(AuthenticationFilter.SUBJECT_KEY);
        try {
            this.authorizationService.authorizeSchemaRead(subject, Collections.singletonList(keyspaceName), Collections.emptyList(), SourceAPI.GRAPHQL, ResourceKind.KEYSPACE);
            return true;
        }
        catch (UnauthorizedException e) {
            return false;
        }
    }

    protected static void replyWithGraphqlError(Response.Status status, String message, @Suspended AsyncResponse asyncResponse) {
        asyncResponse.resume((Object)Response.status((Response.Status)status).entity((Object)ImmutableMap.of((Object)"errors", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"message", (Object)message)))).build());
    }

    protected static void replyWithGraphqlError(Response.Status status, GraphqlErrorException error, @Suspended AsyncResponse asyncResponse) {
        asyncResponse.resume((Object)Response.status((Response.Status)status).entity((Object)ImmutableMap.of((Object)"errors", (Object)ImmutableList.of((Object)error.toSpecification()))).build());
    }
}

