/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web;

import com.google.common.base.MoreObjects;
import io.stargate.auth.AuthenticationSubject;
import io.stargate.auth.AuthorizationService;
import io.stargate.db.Parameters;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundQuery;
import io.stargate.graphql.schema.CassandraFetcher;
import io.stargate.graphql.web.resources.AuthenticationFilter;
import io.stargate.graphql.web.resources.GraphqlCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

public class StargateGraphqlContext {
    private final AuthenticationSubject subject;
    private final DataStore dataStore;
    private final AuthorizationService authorizationService;
    private final Persistence persistence;
    private final GraphqlCache graphqlCache;
    private final BatchContext batchContext = new BatchContext();

    public StargateGraphqlContext(HttpServletRequest request, AuthorizationService authorizationService, Persistence persistence, GraphqlCache graphqlCache) {
        this.subject = (AuthenticationSubject)request.getAttribute(AuthenticationFilter.SUBJECT_KEY);
        this.dataStore = (DataStore)request.getAttribute(AuthenticationFilter.DATA_STORE_KEY);
        this.authorizationService = authorizationService;
        this.persistence = persistence;
        this.graphqlCache = graphqlCache;
        if (this.subject == null) {
            throw new AssertionError((Object)"Missing authentication subject in the request");
        }
    }

    public AuthenticationSubject getSubject() {
        return this.subject;
    }

    public BatchContext getBatchContext() {
        return this.batchContext;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public GraphqlCache getGraphqlCache() {
        return this.graphqlCache;
    }

    public static class BatchContext {
        private final List<BoundQuery> queries = new ArrayList<BoundQuery>();
        private int operationCount;
        private final CompletableFuture<List<Row>> executionFuture = new CompletableFuture();
        private final AtomicReference<Parameters> parameters = new AtomicReference();

        public CompletableFuture<List<Row>> getExecutionFuture() {
            return this.executionFuture;
        }

        public synchronized List<BoundQuery> getQueries() {
            return this.queries;
        }

        public void setExecutionResult(CompletableFuture<ResultSet> result) {
            ((CompletableFuture)result.thenApply(rs -> this.executionFuture.complete(rs.rows()))).exceptionally(this.executionFuture::completeExceptionally);
        }

        public void setExecutionResult(Exception ex) {
            this.executionFuture.completeExceptionally(ex);
        }

        public synchronized int add(BoundQuery query) {
            this.queries.add(query);
            ++this.operationCount;
            return this.operationCount;
        }

        public synchronized int add(List<BoundQuery> newQueries) {
            this.queries.addAll(newQueries);
            ++this.operationCount;
            return this.operationCount;
        }

        public boolean setParameters(Parameters newParameters) {
            Parameters currentParameters;
            while ((currentParameters = this.parameters.get()) == null) {
                if (!this.parameters.compareAndSet(null, newParameters)) continue;
                return true;
            }
            return newParameters.equals(currentParameters);
        }

        public Parameters getParameters() {
            return (Parameters)MoreObjects.firstNonNull((Object)this.parameters.get(), (Object)CassandraFetcher.DEFAULT_PARAMETERS);
        }
    }
}

