/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.web;

import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.cli.Cli;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.ResourceConfigurationSourceProvider;
import io.dropwizard.forms.MultiPartBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.JarLocation;
import io.stargate.auth.AuthenticationService;
import io.stargate.auth.AuthorizationService;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.DataStoreFactory;
import io.stargate.graphql.GraphqlActivator;
import io.stargate.graphql.web.resources.AdminResource;
import io.stargate.graphql.web.resources.AuthenticationFilter;
import io.stargate.graphql.web.resources.DdlResource;
import io.stargate.graphql.web.resources.DmlResource;
import io.stargate.graphql.web.resources.FilesResource;
import io.stargate.graphql.web.resources.GraphqlCache;
import io.stargate.graphql.web.resources.PlaygroundResource;
import io.stargate.metrics.jersey.ResourceMetricsEventListener;
import java.io.OutputStream;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DropwizardServer
extends Application<Configuration> {
    private final Persistence persistence;
    private final AuthenticationService authenticationService;
    private final AuthorizationService authorizationService;
    private final DataStoreFactory dataStoreFactory;
    private final boolean enableGraphqlFirst;
    private final boolean enableGraphqlPlayground;
    private final Metrics metrics;
    private final HttpMetricsTagProvider httpMetricsTagProvider;
    private volatile Server jettyServer;

    public DropwizardServer(Persistence persistence, AuthenticationService authenticationService, AuthorizationService authorizationService, Metrics metrics, HttpMetricsTagProvider httpMetricsTagProvider, DataStoreFactory dataStoreFactory, boolean enableGraphqlFirst, boolean enableGraphqlPlayground) {
        this.persistence = persistence;
        this.authenticationService = authenticationService;
        this.authorizationService = authorizationService;
        this.metrics = metrics;
        this.httpMetricsTagProvider = httpMetricsTagProvider;
        this.dataStoreFactory = dataStoreFactory;
        this.enableGraphqlFirst = enableGraphqlFirst;
        this.enableGraphqlPlayground = enableGraphqlPlayground;
    }

    public void run(String ... arguments) {
        Bootstrap bootstrap = new Bootstrap((Application)this);
        this.addDefaultCommands(bootstrap);
        this.initialize((Bootstrap<Configuration>)bootstrap);
        Cli cli = new Cli(new JarLocation(((Object)((Object)this)).getClass()), bootstrap, (OutputStream)System.out, (OutputStream)System.err);
        cli.run(arguments).ifPresent(arg_0 -> ((DropwizardServer)this).onFatalError(arg_0));
    }

    public void run(Configuration config, Environment environment) throws Exception {
        final GraphqlCache graphqlCache = new GraphqlCache(this.persistence, this.dataStoreFactory, this.enableGraphqlFirst);
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(graphqlCache).to(GraphqlCache.class);
            }
        });
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(DropwizardServer.this.authorizationService).to(AuthorizationService.class);
            }
        });
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(FrameworkUtil.getBundle(GraphqlActivator.class)).to(Bundle.class);
            }
        });
        environment.jersey().register((Object)new AuthenticationFilter(this.authenticationService, this.dataStoreFactory));
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(DropwizardServer.this.persistence).to(Persistence.class);
            }
        });
        if (this.enableGraphqlPlayground) {
            environment.jersey().register(PlaygroundResource.class);
        }
        environment.jersey().register(DmlResource.class);
        environment.jersey().register(DdlResource.class);
        if (this.enableGraphqlFirst) {
            environment.jersey().register(AdminResource.class);
            environment.jersey().register(FilesResource.class);
        }
        this.enableCors(environment);
        ResourceMetricsEventListener metricListener = new ResourceMetricsEventListener(this.metrics, this.httpMetricsTagProvider, "graphqlapi");
        environment.jersey().register((Object)metricListener);
        environment.lifecycle().addServerLifecycleListener(server -> {
            this.jettyServer = server;
        });
    }

    public void initialize(Bootstrap<Configuration> bootstrap) {
        super.initialize(bootstrap);
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new ResourceConfigurationSourceProvider());
        bootstrap.setMetricRegistry(this.metrics.getRegistry("graphqlapi"));
        bootstrap.addBundle((ConfiguredBundle)new MultiPartBundle());
    }

    private void enableCors(Environment environment) {
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("cors", CrossOriginFilter.class);
        filter.setInitParameter("allowedMethods", "POST,GET,OPTIONS,PUT,DELETE,PATCH");
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("Access-Control-Allow-Origin", "*");
        filter.setInitParameter("allowedHeaders", "*");
        filter.setInitParameter("allowCredentials", "true");
        filter.setInitParameter("exposedHeaders", "Date");
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
    }

    public void stop() throws Exception {
        Server s = this.jettyServer;
        if (s != null) {
            s.stop();
        }
    }

    protected void bootstrapLogging() {
    }
}

