/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.graphql.schema.graphqlfirst.processor;

import com.google.common.collect.ImmutableList;
import graphql.language.FieldDefinition;
import io.stargate.graphql.schema.graphqlfirst.processor.DeleteModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.graphql.schema.graphqlfirst.processor.InsertModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModel;
import io.stargate.graphql.schema.graphqlfirst.processor.MutationModelBuilder;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.graphql.schema.graphqlfirst.processor.ProcessingErrorType;
import io.stargate.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.graphql.schema.graphqlfirst.processor.UpdateModelBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class MutationModelFactory {
    public static MutationModel build(FieldDefinition mutation, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) throws SkipException {
        return (MutationModel)MutationModelFactory.detectType(mutation, context).getBuilder(mutation, parentTypeName, entities, responsePayloads, context).build();
    }

    private static Kind detectType(FieldDefinition mutation, ProcessingContext context) throws SkipException {
        for (Kind kind : Kind.values()) {
            if (!mutation.hasDirective(kind.getDirectiveName())) continue;
            return kind;
        }
        for (Kind kind : Kind.values()) {
            for (String prefix : kind.getPrefixes()) {
                if (!mutation.getName().startsWith(prefix)) continue;
                context.addInfo(mutation.getSourceLocation(), "Mutation %s: mapping to a CQL %s because it starts with '%s'", new Object[]{mutation.getName(), kind, prefix});
                return kind;
            }
        }
        context.addError(mutation.getSourceLocation(), ProcessingErrorType.InvalidMapping, "Mutation %s: could not infer mutation kind. Either use one of the mutation directives (%s), or name your operation with a recognized prefix.", mutation.getName(), Arrays.stream(Kind.values()).map(Kind::getDirectiveName).collect(Collectors.joining(", ")));
        throw SkipException.INSTANCE;
    }

    @FunctionalInterface
    static interface BuilderProvider {
        public MutationModelBuilder get(FieldDefinition var1, String var2, Map<String, EntityModel> var3, Map<String, ResponsePayloadModel> var4, ProcessingContext var5);
    }

    private static enum Kind {
        INSERT(InsertModelBuilder::new, "cql_insert", "insert", "create", "bulk"),
        UPDATE(UpdateModelBuilder::new, "cql_update", "update"),
        DELETE(DeleteModelBuilder::new, "cql_delete", "delete", "remove");

        private final BuilderProvider builderProvider;
        private final String directiveName;
        private final Iterable<String> prefixes;

        private Kind(BuilderProvider builderProvider, String directiveName, String ... prefixes) {
            this.builderProvider = builderProvider;
            this.directiveName = directiveName;
            this.prefixes = ImmutableList.copyOf((Object[])prefixes);
        }

        String getDirectiveName() {
            return this.directiveName;
        }

        Iterable<String> getPrefixes() {
            return this.prefixes;
        }

        MutationModelBuilder getBuilder(FieldDefinition mutation, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
            return this.builderProvider.get(mutation, parentTypeName, entities, responsePayloads, context);
        }
    }
}

